//
//  ConversionEngine.m
//  FCIM
//
//  Created by Andrew Choi on 27/08/08.
//  Copyright 2008 Andrew Choi. All rights reserved.
//

/*
 
 Permission for the use of this code is granted only for research, educational, and non-commercial purposes.
 
 Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.
 
 Andrew Choi is not liable for any losses or damages caused by the use of this software.
 
 */

#import "ConversionEngine.h"

@implementation ConversionEngine

- (id)init
{
    self = [super init];
    
	if (self)
	{
		characters = [[NSDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"FCIMCharacters" ofType:@"plist"]];
		if (!characters)
			@throw [NSException exceptionWithName:@"ConversionEngine init" reason:@"No characters dictionary" userInfo:nil];

		phrases = [[NSDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"FCIMPhrases" ofType:@"plist"]];
		if (!phrases)
			@throw [NSException exceptionWithName:@"ConversionEngine init" reason:@"No phrases dictionary" userInfo:nil];
		
		punctuations = [[NSDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"FCIMPunctuations" ofType:@"plist"]];
		if (!phrases)
			@throw [NSException exceptionWithName:@"ConversionEngine init" reason:@"No punctuations dictionary" userInfo:nil];
    }
    
	return self;
}

- (void)dealloc
{
	[characters release];
	[phrases release];
	[punctuations release];
	
	[super dealloc];
}

static ConversionEngine *sharedInstance = nil;

+ (void)allocateSharedInstance
{
	sharedInstance = [[self alloc] init];
}

+ (void)deallocateSharedInstance
{
	[sharedInstance release];
}

+ (ConversionEngine *)sharedInstance
{
	return sharedInstance;
}

- (NSDictionary *)characters
{
	return characters;
}

- (NSDictionary *)phrases
{
	return phrases;
}

- (NSDictionary *)punctuations
{
	return punctuations;
}

@end
