//
//  FCIMDatabaseBuilder.m
//  FCIMDatabaseBuilder
//
//  Created by Andrew Choi on 19/08/08.
//  Copyright 2008 Andrew Choi. All rights reserved.
//

/*
 
 Permission for the use of this code is granted only for research, educational, and non-commercial purposes.
 
 Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.
 
 Andrew Choi is not liable for any losses or damages caused by the use of this software.
 
 */

#import <Foundation/Foundation.h>

#import "CharacterPronunciations.h"
#import "CharacterFrequency.h"
#import "Phrases.h"

void addToDictionary(NSMutableDictionary *dictionary, NSString *pronunciation, NSString *unicode)
{
	NSArray *unicodeCharacters = [dictionary objectForKey:pronunciation];
	if (unicodeCharacters)
	{
		if (![unicodeCharacters containsObject:unicode])
			[dictionary setObject:[unicodeCharacters arrayByAddingObject:unicode] forKey:pronunciation];
	}
	else
		[dictionary setObject:[NSArray arrayWithObject:unicode] forKey:pronunciation];
}

NSInteger compareCharacterFrequency(id num1, id num2, void *context)
{
	CharacterFrequency *characterFrequency = context;
	
	return [characterFrequency compareFrequencyOfChar:num1 withChar:num2];
}

NSArray *sortByCharacterFrequencies(NSArray *unicodeCharacters, CharacterFrequency *characterFrequency)
{
	return [unicodeCharacters sortedArrayUsingFunction:compareCharacterFrequency context:characterFrequency];
}

NSDictionary *sortDictionaryByCharacterFrequencies(NSDictionary *pronunciationToCharacterDictionary, CharacterFrequency *characterFrequency)
{
	NSMutableDictionary *result = [NSMutableDictionary dictionaryWithCapacity:0];
	
	NSEnumerator *e = [pronunciationToCharacterDictionary keyEnumerator];
	NSString *pronunciation;
	while ((pronunciation = [e nextObject]))
	{
		NSArray *unicodeCharacters = [pronunciationToCharacterDictionary objectForKey:pronunciation];
		[result setObject:sortByCharacterFrequencies(unicodeCharacters, characterFrequency) forKey:pronunciation];
	}
	
	return result;
}

NSInteger comparePhraseFrequency(id num1, id num2, void *context)
{
	CharacterFrequency *characterFrequency = context;
	
	return [characterFrequency compareFrequencyOfPhrase:num1 withPhrase:num2];
}

NSArray *sortByPhraseFrequencies(NSArray *phrases, CharacterFrequency *characterFrequency)
{
	return [phrases sortedArrayUsingFunction:comparePhraseFrequency context:characterFrequency];
}

NSDictionary *sortDictionaryByPhraseFrequencies(NSDictionary *pronunciationToPhraseDictionary, CharacterFrequency *characterFrequency)
{
	NSMutableDictionary *result = [NSMutableDictionary dictionaryWithCapacity:0];
	
	NSEnumerator *e = [pronunciationToPhraseDictionary keyEnumerator];
	NSString *pronunciation;
	while ((pronunciation = [e nextObject]))
	{
		NSArray *phrases = [pronunciationToPhraseDictionary objectForKey:pronunciation];
		[result setObject:sortByPhraseFrequencies(phrases, characterFrequency) forKey:pronunciation];
	}
	
	return result;
}

NSDictionary *buildPronunciationToCharacterDictionary(CharacterPronunciations *characterPronunciations)
{
	NSMutableDictionary *pronunciationToCharacterDictionary = [NSMutableDictionary dictionaryWithCapacity:0];
	
	NSEnumerator *e = [[characterPronunciations dictionary] keyEnumerator];
	NSString *character;
	while ((character = [e nextObject]))
	{
		NSArray *pronunciations = [[characterPronunciations dictionary] objectForKey:character];
		
		NSEnumerator *e2 = [pronunciations objectEnumerator];
		NSString *pronunciation;
		while ((pronunciation = [e2 nextObject]))
			addToDictionary(pronunciationToCharacterDictionary, pronunciation, character);
	}
	
	return pronunciationToCharacterDictionary;
}

int main (int argc, const char * argv[])
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	CharacterPronunciations *characterPronunciations = [CharacterPronunciations characterPronunciationsWithFile:@"../../Unihan.txt"];
	
	//[[characterPronunciations dictionary] writeToFile:@"../../temp-cp.plist" atomically:YES];	
	
	NSDictionary *pronunciationToCharacterDictionary = buildPronunciationToCharacterDictionary(characterPronunciations);
	
	CharacterFrequency *characterFrequency = [CharacterFrequency characterFrequencyWithFile:@"../../94charfreq.txt"];
	
	NSDictionary *sortedPronunciationToCharacterDictionary = sortDictionaryByCharacterFrequencies(pronunciationToCharacterDictionary, characterFrequency);

	[sortedPronunciationToCharacterDictionary writeToFile:@"../../FCIMCharacters.plist" atomically:YES];
	
	Phrases *phrases = [Phrases phrasesWithFile:@"../../TSAIWORD.TXT" characterPronunciations:characterPronunciations];
		
	NSDictionary *sortedPronunciationToPhraseDictionary = sortDictionaryByPhraseFrequencies([phrases dictionary], characterFrequency);

	[sortedPronunciationToPhraseDictionary writeToFile:@"../../FCIMPhrases.plist" atomically:YES];
	
	[pool drain];
    return 0;
}
