//
//  Phrases.m
//  FCIMDatabaseBuilder
//
//  Created by Andrew Choi on 19/08/08.
//  Copyright 2008 Andrew Choi. All rights reserved.
//

/*
 
 Permission for the use of this code is granted only for research, educational, and non-commercial purposes.
 
 Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.
 
 Andrew Choi is not liable for any losses or damages caused by the use of this software.
 
 */

#import "Phrases.h"

@implementation Phrases

NSArray *allPronunciations(NSString *phrase, CharacterPronunciations *characterPronunciations)
{
	if ([phrase length] == 0)
		return [NSArray arrayWithObject:@""];
	else
	{
		NSArray *pronunciations = allPronunciations([phrase substringFromIndex:1], characterPronunciations);
		
		NSString *currentCharacter = [phrase substringToIndex:1];
		NSArray *currentCharacterPronunciations = [[characterPronunciations dictionary] objectForKey:currentCharacter];
		
		if (!currentCharacterPronunciations)
			@throw [NSException exceptionWithName:@"allPronunciations:" reason:@"No pronunciation for character" userInfo:nil];
		
		NSMutableArray *result = [NSMutableArray arrayWithCapacity:[currentCharacterPronunciations count] * [pronunciations count]];
	
		NSEnumerator *e = [currentCharacterPronunciations objectEnumerator];
		NSString *currentCharacterPronunciation;
		while ((currentCharacterPronunciation = [e nextObject]))
		{
			NSEnumerator *e2 = [pronunciations objectEnumerator];
			NSString *pronunciation;
			while ((pronunciation = [e2 nextObject]))
				[result addObject:[currentCharacterPronunciation stringByAppendingString:pronunciation]];
		}
		
		return result;
	}
}

- (void)addPhrase:(NSString *)phrase forPronunciation:(NSString *)pronunciation
{
	NSArray *phrases = [dictionary objectForKey:pronunciation];
	if (phrases)
	{
		if (![phrases containsObject:phrase])
			[dictionary setObject:[phrases arrayByAddingObject:phrase] forKey:pronunciation];
	}
	else
		[dictionary setObject:[NSArray arrayWithObject:phrase] forKey:pronunciation];
}

- (Phrases *)initWithFile:(NSString *)filename characterPronunciations:(CharacterPronunciations *)characterPronunciations
{
    self = [super init];
    
	if (self)
	{
		dictionary = [[NSMutableDictionary alloc] initWithCapacity:0];
		
		NSData *data = [NSData dataWithContentsOfFile:filename];
		
		// File encoded in Big5 with DOS newlines.  Yikes!
		
		const char *bytes = [data bytes];
		int len = [data length];
		int i = 0;
		int j;
		
		while (i < len)
		{
			j = i;
			while (bytes[j] != '\r' && j + 1 < len && bytes[j + 1] != '\n')
				j++;
			
			NSString *phrase = [[NSString alloc] initWithBytes:&bytes[i] length:j - i encoding:CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingBig5)];
			
			//NSLog(@"%@", phrase);
			if ([phrase length] > 1)
			{
				@try {
					NSArray *pronunciations = allPronunciations(phrase, characterPronunciations);
					
					//NSLog(@"%@ %@", phrase, pronunciations);
				
					NSEnumerator *e = [pronunciations objectEnumerator];
					NSString *pronunciation;
					while ((pronunciation = [e nextObject]))
						[self addPhrase:phrase forPronunciation:pronunciation];
				}
				@catch (NSException *exception) {
					NSLog(@"Cannot determine pronunciation for phrase: %@", phrase);
				}
			}
			
			[phrase release];
			
			i = j + 2;
		}		
    }
    
	return self;
}

- (void)dealloc
{
	[dictionary release];
	
	[super dealloc];
}

+ (Phrases *)phrasesWithFile:(NSString *)filename characterPronunciations:(CharacterPronunciations *)characterPronunciations
{
	return [[[Phrases alloc] initWithFile:filename characterPronunciations:characterPronunciations] autorelease];
}

- (NSDictionary *)dictionary
{
	return dictionary;
}

@end
