//
//  FontSelectionController.m
//  FCIM
//
//  Created by Andrew Choi on 31/08/08.
//  Copyright 2008 Andrew Choi. All rights reserved.
//

/*
 
 Permission for the use of this code is granted only for research, educational, and non-commercial purposes.
 
 Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.
 
 Andrew Choi is not liable for any losses or damages caused by the use of this software.
 
 */

#import "FontSelectionController.h"

@implementation FontSelectionController

- (void)awakeFromNib
{
	[fontNamePopUpButton removeAllItems];
	
	fontNames = [[NSMutableArray alloc] initWithCapacity:0];
	
	NSFontManager *fontManager = [NSFontManager sharedFontManager];
	
	NSEnumerator *e = [[fontManager availableFonts] objectEnumerator];
	NSString *fontName;
	while ((fontName = [e nextObject]))
	{
		NSFont *font = [NSFont fontWithName:fontName size:0.0];
		
		if ([font mostCompatibleStringEncoding] == CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingMacChineseTrad))
		{
			[fontNamePopUpButton addItemWithTitle:[font displayName]];
			[fontNames addObject:fontName];
		}
	}
	
	NSUserDefaults *defaultsDictionary = [NSUserDefaults standardUserDefaults];
	NSString *candidateFontName = [defaultsDictionary objectForKey:@"candidateFontName"];
	float candidateFontSize = [[defaultsDictionary objectForKey:@"candidateFontSize"] floatValue];

	[fontNamePopUpButton selectItemWithTitle:[[NSFont fontWithName:candidateFontName size:0.0] displayName]];
	
	[fontSizePopUpButton selectItemWithTitle:[NSString stringWithFormat:@"%g", candidateFontSize]];
}

- (void)dealloc
{
	[fontNames release];
	
	[super dealloc];
}

- (IBAction)changeFont:(id)sender
{
	NSUserDefaults *defaultsDictionary = [NSUserDefaults standardUserDefaults];
	
	[defaultsDictionary setValue:[fontNamePopUpButton titleOfSelectedItem] forKey:@"candidateFontName"];
	
	NSScanner *scanner = [NSScanner scannerWithString:[fontSizePopUpButton titleOfSelectedItem]];
	float candidateFontSize;
	if ([scanner scanFloat:&candidateFontSize])
		[defaultsDictionary setValue:[NSNumber numberWithFloat:candidateFontSize] forKey:@"candidateFontSize"];	
}

@end
