//
//  main.m
//  FCIM
//
//  Created by Andrew Choi on 22/08/08.
//  Copyright 2008 Andrew Choi. All rights reserved.
//

/*
 
 Permission for the use of this code is granted only for research, educational, and non-commercial purposes.
 
 Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.
 
 Andrew Choi is not liable for any losses or damages caused by the use of this software.
 
 */

#import <Cocoa/Cocoa.h>
#import <InputMethodKit/InputMethodKit.h>

#import "FCIMCandidates.h"
#import "ConversionEngine.h"

const NSString* serverConnectionName = @"FCIMServerConnection";

int main(int argc, char *argv[])
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	IMKServer* server = [[IMKServer alloc] initWithName:(NSString*)serverConnectionName bundleIdentifier:[[NSBundle mainBundle] bundleIdentifier]];
	[FCIMCandidates allocateSharedInstanceWithServer:server];
	[ConversionEngine allocateSharedInstance];
	
    // Load the bundle explicitly because the input method server is a background only application.
	[NSBundle loadNibNamed:@"MainMenu" owner:[NSApplication sharedApplication]];
	
	[[NSApplication sharedApplication] run];
	
	[ConversionEngine deallocateSharedInstance];
	[FCIMCandidates deallocateSharedInstance];
	[server release];

    [pool release];

    return 0;
}
