#import "ApplicationDelegate.h"

@implementation ApplicationDelegate

+ (void)initialize
{
  NSFont *font = [NSFont systemFontOfSize:0];
  
  [[NSUserDefaults standardUserDefaults] registerDefaults:[NSDictionary dictionaryWithObjectsAndKeys: [font fontName], @"Name", [NSNumber numberWithFloat:[font pointSize]], @"Size", nil]];
}

- (void)awakeFromNib
{
  [fontSampleCustomView bind:@"name" toObject:[NSUserDefaultsController sharedUserDefaultsController] withKeyPath:@"values.Name" options:nil];
  [fontSampleCustomView bind:@"size" toObject:[NSUserDefaultsController sharedUserDefaultsController] withKeyPath:@"values.Size" options:nil];  
}

- (IBAction)setChordFont:(id)sender
{
  NSDictionary *defaultsDictionary = [[NSUserDefaultsController sharedUserDefaultsController] values];
  NSFont *font = [NSFont fontWithName:[defaultsDictionary valueForKey:@"Name"] size:[[defaultsDictionary valueForKey:@"Size"] floatValue]];
  
  [[NSFontManager sharedFontManager] setSelectedFont:font isMultiple:NO];
  [[NSFontManager sharedFontManager] orderFrontFontPanel:self];
}

- (void)changeFont:(id)sender
{
  NSDictionary *defaultsDictionary = [[NSUserDefaultsController sharedUserDefaultsController] values];
  NSFont *oldFont = [NSFont fontWithName:[defaultsDictionary valueForKey:@"Name"] size:[[defaultsDictionary valueForKey:@"Size"] floatValue]];
  
  NSFont *newFont = [sender convertFont:oldFont];

  [defaultsDictionary setValue:[newFont fontName] forKey:@"Name"];
  [defaultsDictionary setValue:[NSNumber numberWithFloat:[newFont pointSize]] forKey:@"Size"];
}

@end
