//
//  FontSampleCustomView.m
//  FontSampleCustomViewTest
//
//  Created by Andrew Choi on 10/08/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "FontSampleCustomView.h"

@implementation FontSampleCustomView

static void *NameObservationContext = (void *)2091;
static void *SizeObservationContext = (void *)2092;

+ (void)initialize
{
  [self exposeBinding:@"name"];	
  [self exposeBinding:@"size"];	
}

- (Class)valueClassForBinding:(NSString *)binding
{
  if ([binding isEqualToString:@"name"])
    return [NSString class];
  else if ([binding isEqualToString:@"size"])
    return [NSNumber class];
  else
    return nil;
}

- (id)initWithFrame:(NSRect)frame
{
  self = [super initWithFrame:frame];
  if (self) {
    // Initialization code here.
  }
  return self;
}

- (void)drawRect:(NSRect)rect
{
  unichar chars[] = { 'C', 0x266f, 'm', '7', 0x266d, '5' };
  NSString *chordString = [NSString stringWithCharacters:chars length:6];
  NSDictionary *attribs = [NSDictionary dictionaryWithObject:[NSFont fontWithName:name size:[size floatValue]] forKey:NSFontAttributeName];
  
  NSSize chordSize = [chordString sizeWithAttributes:attribs];
  NSSize frameSize = [self frame].size;
  
  [chordString drawAtPoint:NSMakePoint((frameSize.width - chordSize.width) / 2.0, (frameSize.height - chordSize.height) / 2.0) withAttributes:attribs];
}

- (void)bind:(NSString *)binding toObject:(id)observableController withKeyPath:(NSString *)keyPath options:(NSDictionary *)options
{
  if ([binding isEqualToString:@"name"])
  {
    [observableController addObserver:self forKeyPath:keyPath options:nil context:NameObservationContext];
  }
  else if ([binding isEqualToString:@"size"])
  {
    [observableController addObserver:self forKeyPath:keyPath options:nil context:SizeObservationContext];
  }
  
  [super bind:binding toObject:observableController withKeyPath:keyPath options:options];
  
  [self setNeedsDisplay:YES];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
  [self setNeedsDisplay:YES];
}

@end
