//
//  AliasUtilities.m
//  MIDIDevicePopupTest
//
//  Created by Andrew Choi on 16/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "AliasUtilities.h"

NSString *POSIXPathnameFromAliasData(CFDataRef data)
{
  /* Recreate alias from NSData.  */
  AliasHandle alias = (AliasHandle) NewHandle(CFDataGetLength(data));
  if (!alias)
    RAISE_EXCEPTION(@"Cannot create second Alias\n");
  HLock((Handle)alias);
  BlockMoveData(CFDataGetBytePtr(data), *alias, CFDataGetLength(data));
  HUnlock((Handle)alias);  
  
  /* Recreate FSRef from alias.  */
  FSRef outFSRef;
  Boolean wasChanged;
  if (FSResolveAlias(NULL, alias, &outFSRef, &wasChanged) != noErr)
    RAISE_EXCEPTION(@"Cannot resolve Alias\n");
  
  DisposeHandle((Handle)alias);
  
  /* Recreate URL from FSRef.  */
  CFURLRef outURL = CFURLCreateFromFSRef(NULL, &outFSRef);
  if (!outURL)
    RAISE_EXCEPTION(@"Cannot create URL from FSRef\n");
  
  /* Recreate POSIX pathname from URL.  */
  CFStringRef outPath = CFURLCopyFileSystemPath(outURL, kCFURLPOSIXPathStyle);
  
  CFRelease(outURL);
  
  return [(NSString *)outPath autorelease];
}

CFDataRef AliasDataFromPOSIXPathname(NSString *pathname)
{
  /* Create URL from POSIX pathname to file.  */
  CFURLRef URL = CFURLCreateWithFileSystemPath(NULL, (CFStringRef)pathname, kCFURLPOSIXPathStyle, false);
  if (!URL)
    RAISE_EXCEPTION(@"Cannot create URL");
  
  /* Create FSRef from URL.  */
  FSRef fsRef;
  if (!CFURLGetFSRef(URL, &fsRef))
    RAISE_EXCEPTION(@"Cannot create FSRef");
  CFRelease(URL);
  
  /* Create alias from FSRef.  */
  AliasHandle alias;
  if (FSNewAlias(NULL, &fsRef, &alias) != noErr)
    RAISE_EXCEPTION(@"Cannot create Alias");
  
  /* Create NSData from alias.  */
  HLock((Handle)alias);
  CFDataRef data = CFDataCreate(NULL, (const UInt8 *)*alias, GetHandleSize((Handle)alias));
  HUnlock((Handle)alias);
  DisposeHandle((Handle)alias);
  
  return data;
}  
