//
//  Device.h
//  MIDIDevicePopupTest
//
//  Created by Andrew Choi on 16/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import <Cocoa/Cocoa.h>
#include <CoreMIDI/MIDIServices.h>

@interface Device : NSObject {
  MIDIDeviceRef deviceRef;
  
  BOOL isMasterNameDocumentLoaded;
  
  NSArray *deviceModes;
  
  NSArray *patchBanks;
}

- (id)initWithDeviceRef:(MIDIDeviceRef)newDeviceRef;

- (NSString *)name;

- (void)setPatchNameList:(NSString *)patchNameList andFile:(NSString *)file forPatchBank:(NSString *)patchBank;

@end
