//
//  PatchBank.m
//  MIDIDevicePopupTest
//
//  Created by Andrew Choi on 22/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "MIDINameDocumentUtilities.h"

#import "PatchBank.h"

@implementation PatchBank

- (id)initWithDevice:(Device *)newDevice name:(NSString *)newName file:(NSString *)newFile patchNameList:(NSString *)newPatchNameList
{
  if (self = [super init])
  {
    device = [newDevice retain];
    
    name = [newName retain];
    file = [newFile retain];
    patchNameList = [newPatchNameList retain];
  }
  return self;
}

- (void)delloc
{
  [device release];
  
  [name release];
  [file release];
  [patchNameList release];

  [super dealloc];
}

- (NSString *)fileDisplayName
{
  return [[NSFileManager defaultManager] displayNameAtPath:[self valueForKey:@"file"]];
}

- (NSArray *)patchNameListChoices
{
  if ([file length] == 0)
    return nil;
  else
    return [PatchNameListsFromFile(file) sortedArrayUsingSelector:@selector(compare:)];
}

- (void)setPatchNameList:(NSString *)newPatchNameList
{
  //NSLog(@"Setting patch name list to %@", newPatchNameList);
  
  [patchNameList release];
  patchNameList = [newPatchNameList retain];
  
  [device setPatchNameList:newPatchNameList andFile:file forPatchBank:name];
}

- (IBAction)chooseFile:(id)sender
{
  NSOpenPanel *op = [NSOpenPanel openPanel];
  [op setAllowsMultipleSelection:NO];
  NSArray *fileTypes = [NSArray arrayWithObjects:@"midnam", @"xml", nil];
  int result;
  NSString *oldMasterNameDocument = file;
  if (oldMasterNameDocument)
    result = [op runModalForDirectory:[oldMasterNameDocument stringByDeletingLastPathComponent] file:[oldMasterNameDocument lastPathComponent] types:fileTypes];
  else
    result = [op runModalForDirectory:nil file:nil types:fileTypes];
  
  if (result == NSOKButton)
  {
    NSString *newFile = [[op filenames] objectAtIndex:0];
    
    NSArray *patchNameLists = PatchNameListsFromFile(newFile);
    if ([patchNameLists count] == 0)
      RAISE_EXCEPTION(@"There must be one or more patch name lists in a MIDI Name Document");
    
    NSString *newPatchNameList = [patchNameLists objectAtIndex:0];

    [device setPatchNameList:newPatchNameList andFile:newFile forPatchBank:name];
    
    [self setValue:newFile forKey:@"file"];
    [self setValue:newPatchNameList forKey:@"patchNameList"];
  }
}

- (IBAction)clearFile:(id)sender
{
  [device setPatchNameList:nil andFile:nil forPatchBank:name];

  [self setValue:nil forKey:@"file"];
  [self setValue:nil forKey:@"patchNameList"];
}

@end
