//
//  RootNode.m
//  TreeControllerFilterTest
//
//  Created by Andrew Choi on 25/08/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "LeafNode.h"

#import "RootNode.h"

@implementation RootNode

- (id)init
{
  if (self = [super init])
  {
    name = [@"Root" retain];
    filtered = NO;
  }
  return self;
}

- (void)delloc
{
  [name release];
  
  [super dealloc];
}

- (void)setFiltered:(BOOL)newFiltered
{
  filtered = newFiltered;
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  if (filtered)
    return 4;
  else
    return 8;
}

- (LeafNode *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[LeafNode alloc] initWithName:[NSString stringWithFormat:@"Leaf %d", index + 1]] autorelease];
}


@end
