//
//  BrowserObject.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "BrowserObject.h"

@implementation BrowserObject

- (NSString *)name
{
  RAISE_EXCEPTION(@"Subclass of BrowserObject must override virtual method \"name\"");
  
  return nil;
}

- (BOOL)isLeaf
{
  RAISE_EXCEPTION(@"Subclass of BrowserObject must override virtual method \"isLeaf\"");
  
  return YES;
}

- (unsigned int)countOfChildren
{
  RAISE_EXCEPTION(@"Subclass of BrowserObject must override virtual method \"countOfChildren\"");

  return 0;
}

- (BrowserObject *)objectInChildrenAtIndex:(unsigned int)index
{
  RAISE_EXCEPTION(@"Subclass of BrowserObject must override virtual method \"objectInChildrenAtIndex:\"");

  return nil;
}

@end
