//
//  Channel.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "PatchBank.h"

#import "Channel.h"

@implementation Channel

- (id)initWithDeviceRef:(MIDIDeviceRef)newDeviceRef channel:(int)newChannel xmlDoc:(NSXMLDocument *)newXMLDoc channelNameSet:(NSString *)newChannelNameSet patchBanks:(NSArray *)newPatchBanks
{
  if (self = [super init])
  {
    deviceRef = newDeviceRef;
    channel = newChannel;
    xmlDoc = [newXMLDoc retain];
    channelNameSet = [newChannelNameSet retain];
    patchBanks = [newPatchBanks retain];
  }
  return self;
}

- (void)delloc
{
  [xmlDoc release];
  [channelNameSet release];
  [patchBanks release];
  
  [super dealloc];
}

- (NSString *)name
{
  return [NSString stringWithFormat:@"%d", channel];
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  return [patchBanks count];
}

- (PatchBank *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[PatchBank alloc] initWithDictionary:[patchBanks objectAtIndex:index]] autorelease];
}

@end
