//
//  Device.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "Channel.h"
#import "MIDINameDocumentUtilities.h"

#import "Device.h"

@implementation Device

- (id)initWithDeviceRef:(MIDIDeviceRef)newDeviceRef
{
  if (self = [super init])
  {
    deviceRef = newDeviceRef;
    
    xmlDoc = [XMLDocFromDeviceRef(deviceRef) retain];
    channelNameSetPatchBanks = [ChannelNameSetPatchBanksFromXMLDoc(xmlDoc) retain];
    
    //NSLog(@"%@", channelNameSetPatchBanks);
    
    currentChannelNameSets = [CurrentChannelNameSetsFromDeviceRef(deviceRef) retain];
  }
  return self;
}

- (void)delloc
{
  [xmlDoc release];
  [channelNameSetPatchBanks release];
  [currentChannelNameSets release];
  
  [super dealloc];
}

- (NSString *)name
{
  CFStringRef cfName;
  MIDIObjectGetStringProperty(deviceRef, kMIDIPropertyName, &cfName);
  
  return [(NSString *)cfName autorelease];
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  return 16;
}

- (Channel *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[Channel alloc] initWithDeviceRef:deviceRef channel:index+1 xmlDoc:xmlDoc channelNameSet:[currentChannelNameSets objectAtIndex:index] patchBanks:[channelNameSetPatchBanks objectForKey:[currentChannelNameSets objectAtIndex:index]]] autorelease];
}

@end
