//
//  MIDINameDocumentUtilities.m
//  MIDIDevicePopupTest
//
//  Created by Andrew Choi on 18/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "AliasUtilities.h"

#import "MIDINameDocumentUtilities.h"

NSXMLDocument *XMLDocFromFile(NSString *filename)
{
  if ([filename length] == 0)
    return nil;
  
  NSError *err = nil;
  
  NSURL *furl = [NSURL fileURLWithPath:filename];
  if (!furl)
    RAISE_EXCEPTION(([NSString stringWithFormat:@"Can't create an URL from file %@", filename]));
  
  NSXMLDocument *xmlDoc = [[NSXMLDocument alloc] initWithContentsOfURL:furl options:(NSXMLNodePreserveWhitespace|NSXMLNodePreserveCDATA) error:&err];
  if (xmlDoc == nil)
    xmlDoc = [[NSXMLDocument alloc] initWithContentsOfURL:furl options:NSXMLDocumentTidyXML error:&err];
  
  if (xmlDoc == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);

  return [xmlDoc autorelease];
}

#if 0
NSArray *DeviceModesFromXMLDocument(NSXMLDocument *xmlDoc)
{
  NSMutableArray *deviceModes = [NSMutableArray arrayWithCapacity:1];

  NSError *err = nil;
  
  NSArray *customDeviceModes = [xmlDoc nodesForXPath:@"./MIDINameDocument/MasterDeviceNames/CustomDeviceMode" error:&err];
  if (customDeviceModes == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);

  for (int i = 0; i < [customDeviceModes count]; i++)
  {
    NSXMLElement *result = [customDeviceModes objectAtIndex:i];
    
    NSArray *name = [result nodesForXPath:@"./@Name" error:&err];
    if (name == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);
    if ([name count] != 1)
      RAISE_EXCEPTION(@"CustomDeviceMode must have exactly one Name attribute");
    
    NSArray *channels = [result nodesForXPath:@"./ChannelNameSetAssignments/ChannelNameSetAssign/@Channel" error:&err];
    if (channels == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);
   
    NSArray *nameSets = [result nodesForXPath:@"./ChannelNameSetAssignments/ChannelNameSetAssign/@NameSet" error:&err];
    if (nameSets == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);
    
    if ([channels count] != [nameSets count])
      RAISE_EXCEPTION(@"CustomDeviceMode must have same number of channels and name sets");
    
    NSMutableArray *channelNameSetAssignments = [NSMutableArray arrayWithCapacity:16];

    for (int j = 0; j < [channels count]; j++)
      [channelNameSetAssignments addObject:[NSDictionary dictionaryWithObjectsAndKeys:[[channels objectAtIndex:j] objectValue], @"channel", [[nameSets objectAtIndex:j] objectValue], @"nameSet", nil]];
    
    [deviceModes addObject:[NSDictionary dictionaryWithObjectsAndKeys:[[name objectAtIndex:0] objectValue], @"name", channelNameSetAssignments, @"channelNameSetAssignments", nil]];
  }
  
  return deviceModes;
}

NSArray *PatchBanksFromXMLDocument(NSXMLDocument *xmlDoc, Device *device, NSDictionary *banks)
{
  //NSLog(@"%@", banks);
  
  if (!xmlDoc)
    return nil;
  
  NSMutableArray *patchBanks = [NSMutableArray arrayWithCapacity:5];
  
  NSError *err = nil;
  
  NSArray *patchBankNames = [xmlDoc nodesForXPath:@"./MIDINameDocument/MasterDeviceNames/ChannelNameSet/PatchBank/@Name" error:&err];
  if (patchBankNames == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);
  
  for (int i = 0; i < [patchBankNames count]; i++)
  {
    NSString *patchBankName = [[patchBankNames objectAtIndex:i] objectValue];
    
    NSDictionary *patchBank = [banks objectForKey:patchBankName];
    CFDataRef fileAliasData = (CFDataRef)[patchBank objectForKey:@"file"];
    NSString *patchNameList = [patchBank objectForKey:@"patchNameList"];
    
    if (fileAliasData)
      [patchBanks addObject:[[[PatchBank alloc] initWithDevice:device name:patchBankName file:POSIXPathnameFromAliasData(fileAliasData) patchNameList:patchNameList] autorelease]];
    else
      [patchBanks addObject:[[[PatchBank alloc] initWithDevice:device name:patchBankName file:nil patchNameList:nil] autorelease]];      
  }

  //NSLog(@"%@", patchBanks);

  return patchBanks;
}

NSArray *PatchNameListsFromFile(NSString *filename)
{
  NSXMLDocument *xmlDoc = XMLDocFromFile(filename);
  
  if (!xmlDoc)
    return nil;
  
  NSMutableArray *patchNameLists = [NSMutableArray arrayWithCapacity:5];
  
  NSError *err = nil;
  
  NSArray *patchNameListNodes = [xmlDoc nodesForXPath:@"./MIDINameDocument/MasterDeviceNames/PatchNameList/@Name" error:&err];
  if (patchNameListNodes == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);
  
  for (int i = 0; i < [patchNameListNodes count]; i++)
    [patchNameLists addObject:[[patchNameListNodes objectAtIndex:i] objectValue]];
    
  NSArray *patchBanks = [xmlDoc nodesForXPath:@"./MIDINameDocument/MasterDeviceNames/ChannelNameSet/PatchBank" error:&err];
  if (patchBanks == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);
  
  for (int i = 0; i < [patchBanks count]; i++)
  {
    NSXMLElement *patchBank = [patchBanks objectAtIndex:i];
    
    NSArray *patchNameList = [patchBank nodesForXPath:@"./PatchNameList" error:&err];
    if (patchNameList == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);

    if ([patchNameList count] == 1)
    {
      NSArray *name = [patchBank nodesForXPath:@"./@Name" error:&err];
      if (name == nil || err)
	RAISE_EXCEPTION([err localizedDescription]);
      if ([name count] != 1)
	RAISE_EXCEPTION(@"CustomDeviceMode must have exactly one Name attribute");

      [patchNameLists addObject:[[name objectAtIndex:0] objectValue]];
    }
  }
  
  return patchNameLists;
}

NSArray *CurrentChannelNameSetFromDeviceMode(NSDictionary *deviceMode)
{
  NSArray *channelNameSetAssignments = [deviceMode objectForKey:@"channelNameSetAssignments"];
  
  NSString *currentChannelNameSets[16] = { nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil };
  
  for (int i = 0; i < [channelNameSetAssignments count]; i++)
  {
    NSDictionary *channelNameSetAssignment = [channelNameSetAssignments objectAtIndex:i];
    int channel = [[channelNameSetAssignment objectForKey:@"channel"] intValue];
    NSString *nameSet = [channelNameSetAssignment objectForKey:@"nameSet"];
    
    if (1 <= channel && channel <= 16)
      currentChannelNameSets[channel - 1] = nameSet;
  }
  
  return [NSArray arrayWithObjects:currentChannelNameSets count:16];
}
#endif

NSXMLDocument *XMLDocFromDeviceRef(MIDIDeviceRef deviceRef)
{
  CFDictionaryRef cfNameConfiguration;
  if (MIDIObjectGetDictionaryProperty(deviceRef, kMIDIPropertyNameConfiguration, &cfNameConfiguration) != noErr)
    return nil;  /* Call fails if property has not been set.  */

  CFDataRef masterAliasData = (CFDataRef)[(NSDictionary *)cfNameConfiguration objectForKey:@"master"];

  [(NSDictionary *)cfNameConfiguration autorelease];
  
  return XMLDocFromFile(POSIXPathnameFromAliasData(masterAliasData));
}

NSDictionary *ChannelNameSetPatchBanksFromXMLDoc(NSXMLDocument *xmlDoc)
{  
  if (!xmlDoc)
    return nil;
  
  NSMutableDictionary *channelNameSetPatchBanks = [NSMutableDictionary dictionaryWithCapacity:2];
  
  NSError *err = nil;
  
  NSArray *channelNameSets = [xmlDoc nodesForXPath:@"./MIDINameDocument/MasterDeviceNames/ChannelNameSet" error:&err];
  if (channelNameSets == nil || err)
    RAISE_EXCEPTION([err localizedDescription]);
  
  for (int i = 0; i < [channelNameSets count]; i++)
  {
    NSXMLElement *result = [channelNameSets objectAtIndex:i];
    
    NSArray *channelNameSetName = [result nodesForXPath:@"./@Name" error:&err];
    if (channelNameSetName == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);
    if ([channelNameSetName count] != 1)
      RAISE_EXCEPTION(@"Channel name set must have exactly one Name attribute");
    
    NSArray *patchBanks = [result nodesForXPath:@"./PatchBank" error:&err];
    if (patchBanks == nil || err)
      RAISE_EXCEPTION([err localizedDescription]);
    
    NSMutableArray *patchBankNames = [NSMutableArray arrayWithCapacity:5];

    for (int j = 0; j < [patchBanks count]; j++)
    {
      NSXMLElement *patchBank = [patchBanks objectAtIndex:j];
      
      NSArray *name = [patchBank nodesForXPath:@"./@Name" error:&err];
      if (name == nil || err)
	RAISE_EXCEPTION([err localizedDescription]);
      if ([name count] != 1)
	RAISE_EXCEPTION(@"Patch bank must have exactly one Name attribute");
      
      NSArray *patchNames = [patchBank nodesForXPath:@"./PatchNameList/Patch/@Name" error:&err];
      if (patchNames == nil || err)
	RAISE_EXCEPTION([err localizedDescription]);
      
      NSMutableArray *patchNameArray = [NSMutableArray arrayWithCapacity:128];
      for (int k = 0; k < [patchNames count]; k++)
	[patchNameArray addObject:[[patchNames objectAtIndex:k] objectValue]];
      
      [patchBankNames addObject:[NSDictionary dictionaryWithObjectsAndKeys:[[name objectAtIndex:0] objectValue], @"bank", patchNameArray, @"patches", nil]];
    }
 
    [channelNameSetPatchBanks setObject:patchBankNames forKey:[[channelNameSetName objectAtIndex:0] objectValue]];
  }
  
  return channelNameSetPatchBanks;
}

NSArray *CurrentChannelNameSetsFromDeviceRef(MIDIDeviceRef deviceRef)
{
  CFDictionaryRef cfNameConfiguration;
  if (MIDIObjectGetDictionaryProperty(deviceRef, kMIDIPropertyNameConfiguration, &cfNameConfiguration) != noErr)
    return nil;  /* Call fails if property has not been set.  */
  
  NSArray *currentChannelNameSets = [(NSDictionary *)cfNameConfiguration objectForKey:@"currentChannelNameSets"];
  
  [(NSDictionary *)cfNameConfiguration autorelease];
  
  return currentChannelNameSets;
}
