//
//  PatchBank.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  Perl Artistic License.

#import "Patch.h"

#import "PatchBank.h"

@implementation PatchBank

- (id)initWithDictionary:(NSDictionary *)newDictionary
{
  if (self = [super init])
  {
    dictionary = [newDictionary retain];
  }
  return self;
}

- (void)delloc
{
  [dictionary release];
  
  [super dealloc];
}

- (NSString *)name
{
  return [dictionary objectForKey:@"bank"];
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  return [[dictionary objectForKey:@"patches"] count];
}

- (Patch *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[Patch alloc] initWithName:[[dictionary objectForKey:@"patches"] objectAtIndex:index]] autorelease];
}

@end
