#include <CoreFoundation/CoreFoundation.h>

#include "exception.h"

void show(CFPropertyListRef p)
{
    CFShow(p);
}

CFPropertyListRef noop(CFPropertyListRef p)
{
    return CFRetain(p);
}

CFPropertyListRef xml(CFPropertyListRef p)
{
    CFDataRef d = CFPropertyListCreateXMLData(kCFAllocatorDefault, p);

    CFStringRef s = CFStringCreateFromExternalRepresentation(kCFAllocatorDefault, d, kCFStringEncodingUTF8);

    CFRelease(d);

    return s;
}

void test_exception(CFPropertyListRef p)
{
    if (CFGetTypeID(p) != CFStringGetTypeID())
        Throw "test_exception expects a string argument";

    CFShow(p);
}
