//
//  BrowserObject.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  All rights reserved.

#import "BrowserObject.h"

@implementation BrowserObject

- (NSString *)name
{
  @throw EXCEPTION(@"Subclass of BrowserObject must override virtual method \"name\"");
  
  return nil;
}

- (BOOL)isLeaf
{
  @throw EXCEPTION(@"Subclass of BrowserObject must override virtual method \"isLeaf\"");
  
  return YES;
}

- (unsigned int)countOfChildren
{
  @throw EXCEPTION(@"Subclass of BrowserObject must override virtual method \"countOfChildren\"");

  return 0;
}

- (BrowserObject *)objectInChildrenAtIndex:(unsigned int)index
{
  @throw EXCEPTION(@"Subclass of BrowserObject must override virtual method \"objectInChildrenAtIndex:\"");

  return nil;
}

@end
