//
//  Channel.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  All rights reserved.

#import "Bank.h"

#import "Channel.h"

@implementation Channel

- (id)initWithDestination:(Destination *)newDestination channel:(int)newChannel
{
  if (self = [super init])
  {
    destination = newDestination;
    channel = newChannel;
    
    banks = (NSArray *) Destination_Banks(destination, channel);
  }
  return self;
}

- (void)delloc
{
  [banks release];
  
  [super dealloc];
}

- (NSString *)name
{
  return [NSString stringWithFormat:@"%d", channel];
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  return [banks count];
}

- (Bank *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[Bank alloc] initWithDestination:destination channel:channel bank:[banks objectAtIndex:index]] autorelease];
}

@end
