//
//  DestinationList.m
//  ProgramPanel
//
//  Created by Andrew Choi on 02/11/05.
//  Copyright 2005 Andrew Choi. All rights reserved.
//

#import "Device.h"

#import "DestinationList.h"

@implementation DestinationList

- (id)init
{
  if (self = [super init])
  {
    Initialize();
    
    destinationList = (NSArray *) Devices(kDeviceTypeDestinations);
  }
  return self;  
}

- (void)delloc
{
  [destinationList release];
  
  Terminate();
  
  [super dealloc];
}

- (unsigned int)countOfDevices
{
  return [destinationList count];
}

- (Device *)objectInDevicesAtIndex:(unsigned int)index
{
  return [[[Device alloc] initWithDeviceDescription:[destinationList objectAtIndex:index]] autorelease];
}

- (IBAction)selectBankAndChangeProgram:(id)sender
{
  NSString *deviceName = [[browser selectedCellInColumn:0] stringValue];
  int channel = [browser selectedRowInColumn:1] + 1;
  NSString *bank = [[browser selectedCellInColumn:2] stringValue];
  NSString *program = [[browser selectedCellInColumn:3] stringValue];
  
  if (!deviceName || channel < 0 || !bank || !program)
  {
    NSBeep();
    return;
  }
  
  Destination *d = new_Destination((CFPropertyListRef) deviceName);
  Destination_Send(d, Destination_BankSelect(d, channel, (CFPropertyListRef) bank));
  Destination_Send(d, Destination_ProgramChange(d, channel, (CFPropertyListRef) bank, (CFPropertyListRef) program));
  delete_Destination(d);
}

@end
