//
//  Device.m
//  TreeControllerTest
//
//  Created by Andrew Choi on 24/08/05.
//  Copyright 2005 Andrew Choi.  All rights reserved.

#import "Channel.h"

#import "Device.h"

@implementation Device

- (id)initWithDeviceDescription:(NSDictionary *)newDeviceDescription
{
  if (self = [super init])
  {
    deviceDescription = [newDeviceDescription retain];
    
    destination = new_Destination((CFPropertyListRef) deviceDescription);
  }
  return self;
}

- (void)delloc
{
  delete_Destination(destination);
  
  [deviceDescription release];
  
  [super dealloc];
}

- (NSString *)name
{
  return [deviceDescription objectForKey:@"DisplayName"];
}

- (BOOL)isLeaf
{
  return NO;
}

- (unsigned int)countOfChildren
{
  return 16;
}

- (Channel *)objectInChildrenAtIndex:(unsigned int)index
{
  return [[[Channel alloc] initWithDestination:destination channel:index+1] autorelease];
}

@end
