/* Copyright (c) 2005 Andrew Choi.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

3. All advertising materials mentioning features or use of this
   software must display the following acknowledgement:

     This product includes software developed by Andrew Choi.

4. The name "Andrew Choi" may not be used to endorse or promote
   products derived from this software without specific prior written
   permission.

THIS SOFTWARE IS PROVIDED BY ANDREW CHOI "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.  IN NO EVENT SHALL ANDREW CHOI BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.  */

#import <CoreServices/CoreServices.h>
#import <Foundation/Foundation.h>

#import "AliasUtilities.h"

CFStringRef POSIXPathnameFromAliasData(CFDataRef data)
{
  /* Recreate alias from NSData.  */
  AliasHandle alias = (AliasHandle) NewHandle(CFDataGetLength(data));
  if (!alias)
    @throw EXCEPTION(@"Cannot create second Alias");
  HLock((Handle)alias);
  BlockMoveData(CFDataGetBytePtr(data), *alias, CFDataGetLength(data));
  HUnlock((Handle)alias);  
  
  /* Recreate FSRef from alias.  */
  FSRef outFSRef;
  Boolean wasChanged;
  if (FSResolveAlias(NULL, alias, &outFSRef, &wasChanged) != noErr)
    @throw EXCEPTION(@"Cannot resolve Alias");
  
  DisposeHandle((Handle)alias);
  
  /* Recreate URL from FSRef.  */
  CFURLRef outURL = CFURLCreateFromFSRef(NULL, &outFSRef);
  if (!outURL)
    @throw EXCEPTION(@"Cannot create URL from FSRef");
  
  /* Recreate POSIX pathname from URL.  */
  CFStringRef outPath = CFURLCopyFileSystemPath(outURL, kCFURLPOSIXPathStyle);
  
  CFRelease(outURL);
  
  return outPath;
}

CFDataRef AliasDataFromPOSIXPathname(CFStringRef pathname)
{
  /* Create URL from POSIX pathname to file.  */
  CFURLRef URL = CFURLCreateWithFileSystemPath(NULL, pathname, kCFURLPOSIXPathStyle, false);
  if (!URL)
    @throw EXCEPTION(@"Cannot create URL");
  
  /* Create FSRef from URL.  */
  FSRef fsRef;
  if (!CFURLGetFSRef(URL, &fsRef))
    @throw EXCEPTION(@"Cannot create FSRef");
  CFRelease(URL);
  
  /* Create alias from FSRef.  */
  AliasHandle alias;
  if (FSNewAlias(NULL, &fsRef, &alias) != noErr)
    @throw EXCEPTION(@"Cannot create Alias");
  
  /* Create NSData from alias.  */
  HLock((Handle)alias);
  CFDataRef data = CFDataCreate(NULL, (const UInt8 *)*alias, GetHandleSize((Handle)alias));
  HUnlock((Handle)alias);
  DisposeHandle((Handle)alias);
  
  return data;
}  
