/* Copyright (c) 2005 Andrew Choi.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

3. All advertising materials mentioning features or use of this
   software must display the following acknowledgement:

     This product includes software developed by Andrew Choi.

4. The name "Andrew Choi" may not be used to endorse or promote
   products derived from this software without specific prior written
   permission.

THIS SOFTWARE IS PROVIDED BY ANDREW CHOI "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.  IN NO EVENT SHALL ANDREW CHOI BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.  */

#ifndef _DEVICE_H
#define _DEVICE_H

#include <CoreFoundation/CoreFoundation.h>
#include <CoreMIDI/MIDIServices.h>

enum DeviceTypes { kDeviceTypeSources, kDeviceTypeDestinations, kDeviceTypePairs };

/* Used in PatchNames.m.  */
extern CFDataRef ConnectionsFromEndpoint(MIDIEndpointRef endpoint);
extern MIDIDeviceRef DeviceFromEndpoint(MIDIEndpointRef endpoint);

/* Used in Sysex.m and Destination.m.  */
extern void EndpointPairFromDeviceDescription(CFPropertyListRef deviceDescription, MIDIEndpointRef *source, MIDIEndpointRef *destination);
extern MIDIEndpointRef DestinationEndpointFromDeviceDescription(CFPropertyListRef deviceDescription);
extern CFPropertyListRef CheckDeviceDescription(CFPropertyListRef deviceDescription);

/* Exported */
extern CFPropertyListRef Devices(int types);

#endif _DEVICE_H
