/*
 * Decompiled with CFR 0.152.
 */
package com.example.helloworld;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;

public class ClockCanvas
extends Canvas {
    private Image clockFaceImage;
    private ScalableGraphics sg = ScalableGraphics.createInstance();

    public ClockCanvas() {
        try {
            this.clockFaceImage = Image.createImage((String)"/ClockFace.png");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load image" + e);
        }
    }

    private SVGImage loadSVGImageAndRotate(String name, float angle) {
        SVGImage image;
        InputStream s = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        try {
            image = (SVGImage)SVGImage.createImage((InputStream)s, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load image" + e);
        }
        float halfWidth = (float)image.getViewportWidth() / 2.0f;
        float halfHeight = (float)image.getViewportHeight() / 2.0f;
        Document d = image.getDocument();
        SVGElement hand = (SVGElement)d.getElementById("hand");
        SVGMatrix t = hand.getMatrixTrait("transform");
        t = t.mTranslate(halfWidth, halfHeight);
        t = t.mRotate(angle);
        t = t.mTranslate(-halfWidth, -halfHeight);
        hand.setMatrixTrait("transform", t);
        return image;
    }

    public void paint(Graphics g) {
        Calendar c = Calendar.getInstance();
        int h = c.get(10);
        int m = c.get(12);
        float mAngle = (float)(360.0 * ((double)m / 60.0));
        float hAngle = (float)(360.0 * ((double)h / 12.0) + 30.0 * ((double)m / 60.0));
        g.setGrayScale(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.clockFaceImage, this.getWidth() / 2, this.getHeight() / 2, 3);
        this.sg.bindTarget((Object)g);
        SVGImage hourHandSVGImage = this.loadSVGImageAndRotate("/HourHand.svg", hAngle);
        hourHandSVGImage.setViewportWidth(this.getWidth());
        hourHandSVGImage.setViewportHeight(this.getHeight());
        this.sg.setRenderingQuality(2);
        this.sg.setTransparency(0.7f);
        this.sg.render(0, 0, (ScalableImage)hourHandSVGImage);
        SVGImage minuteHandSVGImage = this.loadSVGImageAndRotate("/MinuteHand.svg", mAngle);
        minuteHandSVGImage.setViewportWidth(this.getWidth());
        minuteHandSVGImage.setViewportHeight(this.getHeight());
        this.sg.render(0, 0, (ScalableImage)minuteHandSVGImage);
        this.sg.releaseTarget();
    }
}

