//  Copyright 2009 Andrew Choi. All rights reserved.
//
//  Permission for the use of this code is granted only for research,
//  educational, and non-commercial purposes.
//
//  Redistribution of this code or its parts in any form without
//  permission, with or without modification, is prohibited.

package com.example.helloworld;

import java.io.*;
import java.util.Calendar;

import javax.microedition.lcdui.*;
import javax.microedition.m2g.*;
import org.w3c.dom.*;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;

public class ClockCanvas extends Canvas {
    private Image clockFaceImage;
    
    private ScalableGraphics sg = ScalableGraphics.createInstance();
    
    public ClockCanvas () {
    	try {
    		clockFaceImage = Image.createImage("/ClockFace.png");
    	}
    	catch (IOException e) {
    		throw new RuntimeException("Unable to load image" + e);
    	}
    }
	
    private SVGImage loadSVGImageAndRotate(String name, float angle)
    {
		InputStream s = getClass().getResourceAsStream(name);
		SVGImage image;
		
		try {
			image = (SVGImage) SVGImage.createImage(s, null);
		}
    	catch (IOException e) {
    		throw new RuntimeException("Unable to load image" + e);
    	}
  
       	final float halfWidth = ((float) image.getViewportWidth()) / 2.0f;
       	final float halfHeight = ((float) image.getViewportHeight()) / 2.0f;

    	Document d = image.getDocument();
    	SVGElement hand = (SVGElement)d.getElementById("hand");
    	
    	SVGMatrix t = hand.getMatrixTrait("transform");
    	
    	// Rotate w.r.t. the center of the hourHandSVGImage.
    	t = t.mTranslate(halfWidth, halfHeight);
    	t = t.mRotate(angle);
    	t = t.mTranslate(-halfWidth, -halfHeight);
    	
    	hand.setMatrixTrait("transform", t);

    	return image;
    }
    
    public void paint(Graphics g) {
    	final Calendar c = Calendar.getInstance();
    	
    	final int h = c.get(Calendar.HOUR);
    	final int m = c.get(Calendar.MINUTE);
    	
    	final float mAngle = (float) (360.0 * ((float) m / 60.0));
    	final float hAngle = (float) (360.0 * ((float) h / 12.0) + (360.0 / 12.0) * ((float) m / 60.0));
    	    	
    	g.setGrayScale(0);
    	g.fillRect(0, 0, getWidth(), getHeight());
    	
    	g.drawImage(clockFaceImage, getWidth() / 2, getHeight() / 2, Graphics.HCENTER | Graphics.VCENTER);

    	sg.bindTarget(g);
    	
    	SVGImage hourHandSVGImage = loadSVGImageAndRotate("/HourHand.svg", hAngle);
    	
       	hourHandSVGImage.setViewportWidth(getWidth());
    	hourHandSVGImage.setViewportHeight(getHeight());
    	    	
       	sg.setRenderingQuality(ScalableGraphics.RENDERING_QUALITY_HIGH);
       	sg.setTransparency(0.7f);
       	sg.render(0, 0, hourHandSVGImage);
       	
    	SVGImage minuteHandSVGImage = loadSVGImageAndRotate("/MinuteHand.svg", mAngle);
    	
    	minuteHandSVGImage.setViewportWidth(getWidth());
    	minuteHandSVGImage.setViewportHeight(getHeight());
    	
       	sg.render(0, 0, minuteHandSVGImage);
       	
    	sg.releaseTarget();
    }
}
