//  Copyright 2009 Andrew Choi. All rights reserved.
//
//  Permission for the use of this code is granted only for research,
//  educational, and non-commercial purposes.
//
//  Redistribution of this code or its parts in any form without
//  permission, with or without modification, is prohibited.

package com.example.helloworld;

import java.lang.Runnable;
import java.util.Calendar;

import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
 
public class HelloWorldMidlet extends MIDlet implements CommandListener, Runnable {
    
    private Display display;
    
    private ClockCanvas clockCanvas;
    
    private Command exitCommand;

    // Signal to clockCanvas it should be repainted only when hour and minute values
    // has been changed.  This is checked in the loop in another thread (thus
    // inherits from Runnable) every second.
    private int lastHour = -1;
    private int lastMinute = -1;
    private boolean threadStopped = false;
    
    public HelloWorldMidlet() {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == clockCanvas) {
            if (command == exitCommand) {
                exitMIDlet();
            }
        }
    }
        
    public void startApp() {
        display = Display.getDisplay(this);        

        clockCanvas = new ClockCanvas();
        
        exitCommand = new Command("Exit", Command.EXIT, 1);
        clockCanvas.addCommand(exitCommand);
        clockCanvas.setCommandListener(this);
        
        display.setCurrent(clockCanvas);
        
        Thread t = new Thread(this);
        t.start();
    }
    
    public void pauseApp() {
    }
 
    public void destroyApp(boolean unconditional) {
    }
 
    public void exitMIDlet() {
    	threadStopped = true;
    	
        display.setCurrent(null);
        notifyDestroyed();
    }
    
    public void run() {
    	while (!threadStopped) {
    		final Calendar c = Calendar.getInstance();
    	
    		final int h = c.get(Calendar.HOUR);
    		final int m = c.get(Calendar.MINUTE);

    		if (h != lastHour || m != lastMinute) {
    			lastHour = h;
    			lastMinute = m;
    		
    			clockCanvas.repaint();
    		}
    	
    		try {
    			Thread.sleep(1000);
    		}
    		catch (Exception ex) {
    			// Ignore intentionally.
    		}
    	}
    }
}