/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#include <QtGui>

#ifdef QT_MAC_USE_COCOA
#import "ApplicationDelegate.h"
#endif

#include "qtdocbasedapplication.h"
#include "documentwindow.h"
#include "documentwindowmanager.h"

int main(int argc, char *argv[])
{
#ifdef QT_MAC_USE_COCOA
    // Initiate shared application and setup delegate so QApplication constructor (ancestor of QtDocBasedApplication) will pick that up as "reflection delegate" (see src/gui/kernel/qapplication_mac.mm)
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
    [[NSApplication sharedApplication] setDelegate:[[ApplicationDelegate alloc] init]];
    [pool release];
#endif

    // For use of fancy single and double quotes in dialog messages.
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));

    QtDocBasedApplication a(argc, argv);

    QStringList arguments = a.arguments();
    bool anotherInstanceExists = false;
    for (int i = 1; i < arguments.count(); i++)
        anotherInstanceExists |= a.sendMessage(arguments.at(i));

    // Assume another instance of this application exists if *any* of the messages sent was handled.
    if (anotherInstanceExists)
        return 0;

    // Otherwise start this instance.
    QObject::connect(&a, SIGNAL(messageReceived(const QString &)), DocumentWindowManager::instance(), SLOT(openFile(const QString &)));

    if (arguments.count() > 1)
    {
        for (int i = 1; i < arguments.count(); i++)
            DocumentWindowManager::instance()->openFile(arguments.at(i));
    }
    else
        DocumentWindowManager::instance()->newFile();

    return a.exec();
}
