/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#ifndef QTDOCBASEDAPPLICATION_H
#define QTDOCBASEDAPPLICATION_H

#ifdef Q_WS_MAC
#ifndef QT_MAC_USE_COCOA
#include <Carbon/Carbon.h>
#endif
#endif

// The C++-style QtSingleApplication causes "make" to recompile QtSingleApplication.cpp in the library src causing all sorts of "No Such File or Directory" errors on Windows!!  Oh well.
#include <qtsingleapplication.h>

class QEvent;

class QtDocBasedApplication : public QtSingleApplication
{
public:
    QtDocBasedApplication(int &argc, char **argv);
    ~QtDocBasedApplication();

#ifdef Q_WS_MAC
    bool event(QEvent *);
#endif

#ifndef Q_WS_MAC
    void commitData(QSessionManager &sm);
#endif

private:
#ifdef Q_WS_MAC
#ifndef QT_MAC_USE_COCOA
    static OSErr quitApplicationAeHandler(const AppleEvent *, AppleEvent *, long);
    void customEvent(QEvent *event);
#endif
#endif
};

#endif // QTDOCBASEDAPPLICATION_H
