/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#ifndef CHORDEDIT_H
#define CHORDEDIT_H

#include <QLineEdit>
#include <QFont>
#include <QString>
#include <QCompleter>

#include "chordnamemodel.h"

class ChordEdit : public QLineEdit
{
    Q_OBJECT

public:
    ChordEdit();
    void setFont(const QFont &f);
    QSize sizeHint() const;

    QString encode(const QString &str);
    QString decode(const QString &str);

protected:
    void keyPressEvent(QKeyEvent *e);

private slots:
    void handleTextChange(const QString &s);
    void setTextAndHide(const QString &s);
    void setTextAndHighlight(const QString &s);

private:
    QSize bestPopupSize();

    ChordNameModel *model;
    QCompleter *completer;

    int completionPrefixLength;
    bool keyPressedDuringCompletion;

    QChar displaySharpSymbol;
    QChar displayFlatSymbol;
};

#endif // CHORDEDIT_H
