/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#include <QtDebug>

#include "constants.h"

#include "chordedit.h"

#include "chordnamemodel.h"

ChordNameModel::ChordNameModel(QObject *parent) : QAbstractListModel(parent)
{
}

int ChordNameModel::rowCount(const QModelIndex &parent) const
{
    if (parent.isValid())
        return 0;

    return Constants::instance()->noteNames().count() * Constants::instance()->chordTypeNames().count();
}

// This takes much less space than if a string list model was used.
QVariant ChordNameModel::data(const QModelIndex &index, int role) const
{
    if (index.row() < 0 || index.row() >= rowCount(QModelIndex()))
        return QVariant();

    if (role == Qt::DisplayRole || role == Qt::EditRole)
    {
        int i = index.row();
        int n = Constants::instance()->chordTypeNames().count();
        QString noteName = Constants::instance()->noteNames().at(i / n);
        QString chordTypeName = Constants::instance()->chordTypeNames().at(i % n);

        if (ChordEdit *chordEdit = qobject_cast<ChordEdit *>(QObject::parent()))
            return chordEdit->encode(noteName + chordTypeName);
        else
            qFatal("Parent of ChordNameModel isn't ChordEdit");
    }

    return QVariant();
}
