/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#ifndef CHORDVALIDATOR_H
#define CHORDVALIDATOR_H

#include <QRegExpValidator>
#include <QString>

#include "chordedit.h"

class ChordValidator : public QValidator
{
public:
    ChordValidator(QObject *parent);

    State validate(QString &input, int &pos) const;
    void fixup(QString &input) const;

private:
    ChordEdit *getChordEdit() const;
    bool splitChord(const QString &chord, QString &note, QString &alt, QString &chordType) const;
    State caseSensitiveMatch(const QString &s) const;
    State caseInsensitiveMatch(const QString &s, QString &match) const;
};

#endif // CHORDVALIDATOR_H
