/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#include <QtDebug>

#include <QFile>
#include <QTextStream>

#include "constants.h"

Constants *Constants::_instance = 0;

Constants::Constants()
{
    // chordTypeNames
    QFile infile(":/chordtypenames.txt");

    infile.open(QIODevice::ReadOnly);

    QTextStream in(&infile);

    while (!in.atEnd())
        _chordTypeNames.append(in.readLine());

    infile.close();

    // noteNames
    QStringList notes;
    notes << "A" << "B" << "C" << "D" << "E" << "F" << "G";
    QStringList alts;
    alts << "" << "b" << "#" << "bb" << "##";

    foreach (QString n, notes)
    {
        foreach (QString a, alts)
            _noteNames.append(n + a);
    }
}

// Singleton
Constants *Constants::instance()
{
    if (_instance == 0)
    {
        _instance = new Constants;
    }

    return _instance;
}
