/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#include "fontselectionmanager.h"

FontSelectionManager *FontSelectionManager::_instance = 0;

FontSelectionManager::FontSelectionManager()
{
    fontDialog = new QFontDialog(0);
    fontDialog->setOptions(QFontDialog::NoButtons);
    fontDialog->hide();

    connect(fontDialog, SIGNAL(currentFontChanged(QFont)), this, SLOT(fontChangedSlot(QFont)));
}

// Singleton
FontSelectionManager *FontSelectionManager::instance()
{
    if (_instance == 0)
    {
        _instance = new FontSelectionManager;
    }

    return _instance;
}

void FontSelectionManager::fontChangedSlot(const QFont &font)
{
    emit fontChanged(font);
}

// Mimic font panel behavior on Mac.  At most one font panel is shown at any given time.  Clicking a "Select Font..." button shows the font panel (if not already showing).  Selecting a font in it affects the font corresponding to that button (achieved through the slot method of receiver).
void FontSelectionManager::showFontPanel(const QFont &font, const QObject *receiver, const char *method)
{
    disconnect(this, SIGNAL(fontChanged(QFont)), 0, 0);

    connect(this, SIGNAL(fontChanged(QFont)), receiver, method);

    fontDialog->setCurrentFont(font);
    fontDialog->show();
    fontDialog->activateWindow();
}
