/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#ifndef FONTSELECTIONMANAGER_H
#define FONTSELECTIONMANAGER_H

#include <QObject>
#include <QFont>
#include <QFontDialog>

class FontSelectionManager : public QObject
{
    Q_OBJECT

public:
    static FontSelectionManager *instance();

    void showFontPanel(const QFont &font, const QObject *receiver, const char *method);

signals:
    void fontChanged(const QFont &font);

private slots:
    void fontChangedSlot(const QFont &font);

private:
    FontSelectionManager();
    static FontSelectionManager *_instance;

    QFontDialog *fontDialog;
};

#endif // FONTSELECTIONMANAGER_H
