#include "fontselectionmanager.h"

FontSelectionManager *FontSelectionManager::_instance = 0;

FontSelectionManager::FontSelectionManager()
{
    fontDialog = new QFontDialog(0);
    fontDialog->setOptions(QFontDialog::NoButtons);
    fontDialog->hide();

    connect(fontDialog, SIGNAL(currentFontChanged(QFont)), this, SLOT(fontChangedSlot(QFont)));
}

// Singleton
FontSelectionManager *FontSelectionManager::instance()
{
    if (_instance == 0)
    {
        _instance = new FontSelectionManager;
    }

    return _instance;
}

void FontSelectionManager::fontChangedSlot(const QFont &font)
{
    emit fontChanged(font);
}

void FontSelectionManager::showFontPanel(const QFont &font, const QObject *receiver, const char *method)
{
    disconnect(this, SIGNAL(fontChanged(QFont)), 0, 0);

    connect(this, SIGNAL(fontChanged(QFont)), receiver, method);

    fontDialog->setCurrentFont(font);
    fontDialog->show();
    fontDialog->activateWindow();
}
