/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#include <QtGui>

#include "constants.h"
#include "fontselectionmanager.h"

#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    font1 = qApp->font();
    font2 = qApp->font();

    QWidget *centralWidget = new QWidget(this);
    QVBoxLayout *layout = new QVBoxLayout;

    QHBoxLayout *layout1 = new QHBoxLayout;
    QHBoxLayout *layout2 = new QHBoxLayout;

    sampleLineEdit1 = new ChordEdit();
    sampleLineEdit1->setFont(font1);
    //sampleLineEdit1->setStyleSheet("border: 0px; padding: 0;");
    layout1->addWidget(sampleLineEdit1);

    fontFamilyLabel1 = new QLabel(font1.family());
    layout1->addWidget(fontFamilyLabel1);

    QPushButton *setFontButton1 = new QPushButton("Select...");
    layout1->addWidget(setFontButton1);

    //sampleLabel2 = new QLabel("Sample 2");
    sampleLineEdit2 = new ChordEdit();
    sampleLineEdit2->setFont(font2);
    layout2->addWidget(sampleLineEdit2);

    fontFamilyLabel2 = new QLabel(font2.family());
    layout2->addWidget(fontFamilyLabel2);

    QPushButton *setFontButton2 = new QPushButton("Select...");
    layout2->addWidget(setFontButton2);

    layout->addLayout(layout1);
    layout->addLayout(layout2);

    centralWidget->setLayout(layout);
    //centralWidget->setStyleSheet("background: white;");

    setCentralWidget(centralWidget);

    connect(setFontButton1, SIGNAL(pressed()), this, SLOT(setFontButtonPressed1()));
    connect(setFontButton2, SIGNAL(pressed()), this, SLOT(setFontButtonPressed2()));
}

MainWindow::~MainWindow()
{
}

void MainWindow::setFontButtonPressed1()
{
    FontSelectionManager::instance()->showFontPanel(font1, this, SLOT(fontChanged1(QFont)));
}

void MainWindow::setFontButtonPressed2()
{
    FontSelectionManager::instance()->showFontPanel(font2, this, SLOT(fontChanged2(QFont)));
}

void MainWindow::fontChanged1(const QFont &newFont)
{
    font1 = newFont;
    fontFamilyLabel1->setText(font1.family());
    sampleLineEdit1->setFont(font1);
}

void MainWindow::fontChanged2(const QFont &newFont)
{
    font2 = newFont;
    fontFamilyLabel2->setText(font2.family());
    sampleLineEdit2->setFont(font2);
}
