/*
  Permission for the use of this code is granted only for research, educational, and non-commercial purposes.

  Redistribution of this code or its parts in source, binary, and any other form without permission, with or without modification, is prohibited.  Modifications include, but are not limited to, translation to other programming languages and reuse of tables, constant definitions, and API's defined in it.

  Andrew Choi is not liable for any losses or damages caused by the use of this code.

  Copyright 2009 Andrew Choi.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QFont>
#include <QLabel>
#include <QLineEdit>

#include "chordedit.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void setFontButtonPressed1();
    void fontChanged1(const QFont &font);
    void setFontButtonPressed2();
    void fontChanged2(const QFont &font);

private:
    QFont font1;
    ChordEdit *sampleLineEdit1;
    QLabel *fontFamilyLabel1;

    QFont font2;
    ChordEdit *sampleLineEdit2;
    QLabel *fontFamilyLabel2;
};

#endif // MAINWINDOW_H
