# Copyright (c) 2007 Andrew Choi.  All rights reserved.

# This is emphatically NOT free/GPL software.

# Permission for the use of this code is granted only for research,
# educational, and non-commercial purposes.

# Redistribution of this code or its parts in any form without
# permission, with or without modification, is prohibited.
# Modifications include, but are not limited to, translation to other
# programming languages and reuse of tables, constant definitions, and
# API's defined in it.

# There is no restriction on the use of the output generated by this
# software.

# THIS SOFTWARE IS PROVIDED BY ANDREW CHOI "AS IS" AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL ANDREW CHOI BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
#  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.


from toe.core.objects import ChordType

# (Maj) Maj7 Maj9 6 69 Maj7#11
ChordType.define('', ':3.5')
ChordType.define('Maj7', ':3.5.7')
ChordType.define('Maj9', ':3.5.7.9')
ChordType.define('6', ':3.5.6')
ChordType.define('69', ':3.5.6.9')
ChordType.define('Maj7#11', ':3.5.7.#11')

# sus 7sus 9sus
ChordType.define('sus', ':4.5')
ChordType.define('7sus', ':4.5.b7')
ChordType.define('9sus', ':4.5.b7.9')

# m m7 m9 m11 m6 mMaj7
ChordType.define('m', ':b3.5')
ChordType.define('m7', ':b3.5.b7')
ChordType.define('m9', ':b3.5.b7.9')
ChordType.define('m11', ':b3.5.b7.9.11')
ChordType.define('m6', ':b3.5.6')
ChordType.define('mMaj7', ':b3.5.7')

# 7 9 13 7b9 13b9 7#9 13#9 7b5 9b5 7#5 9#5 7+ 9+ 7#5#9 7b5b9 7#5b9
# 7b5#9 7#11 9#11
ChordType.define('7', ':3.5.b7')
ChordType.define('9', ':3.5.b7.9')
ChordType.define('13', ':3.5.b7.9.11.13')
ChordType.define('7b9', ':3.5.b7.b9')
ChordType.define('13b9', ':3.5.b7.b9.11.13')
ChordType.define('7#9', ':3.5.b7.#9')
ChordType.define('13#9', ':3.5.b7.#9.11.13')
ChordType.define('7b5', ':3.b5.b7')
ChordType.define('9b5', ':3.b5.b7.9')
ChordType.define('7#5', ':3.#5.b7')
ChordType.define('9#5', ':3.#5.b7.9')
ChordType.define('7+', ':3.#5.b7')
ChordType.define('9+', ':3.#5.b7.9')
ChordType.define('7#5#9', ':3.#5.b7.#9')
ChordType.define('7b5b9', ':3.b5.b7.b9')
ChordType.define('7#5b9', ':3.#5.b7.b9')
ChordType.define('7b5#9', ':3.b5.b7.#9')
ChordType.define('7#11', ':3.5.b7.#11')
ChordType.define('9#11', ':3.5.b7.9.#11')

# m7b5 dim
ChordType.define('m7b5', ':b3.b5.b7')
ChordType.define('dim', ':b3.b5.bb7')
ChordType.define('dim7', ':b3.b5.bb7')

# + aug
ChordType.define('+', ':3.#5')
ChordType.define('aug', ':3.#5')
