#!/usr/bin/env python

# Copyright (c) 2007 Andrew Choi.  All rights reserved.

# This is emphatically NOT free/GPL software.

# Permission for the use of this code is granted only for research,
# educational, and non-commercial purposes.

# Redistribution of this code or its parts in any form without
# permission, with or without modification, is prohibited.
# Modifications include, but are not limited to, translation to other
# programming languages and reuse of tables, constant definitions, and
# API's defined in it.

# There is no restriction on the use of the output generated by this
# software.

# THIS SOFTWARE IS PROVIDED BY ANDREW CHOI "AS IS" AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL ANDREW CHOI BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
#  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.


import re

from random import randint, seed
from sys import maxint, argv, path
from traceback import print_exc

from toe.io.toereader import read_toe_file
from toe.io.biabreader import read_biab_file
from toe.midi.midifile import write_midi_file

from styles.swing.gen import gen

BIAB_FILENAME_RE = re.compile('^.*\.(sg|mg)([1-9]|[a-n]|u)$', re.IGNORECASE)
TOE_FILENAME_RE = re.compile('^.*\.(mjb|toe)$', re.IGNORECASE)

def analyze_file(f):
    if BIAB_FILENAME_RE.match(f):
        chart = read_biab_file(f)
    elif TOE_FILENAME_RE.match(f):
        chart = read_toe_file(f)
    else:
        raise ValueError('Unknown input file type: %s' % f)

    key = chart['key']
    is_minor = False
    if key[-1] == 'm':
        is_minor = True
        key = key[:-1]

    sequences = gen(chart)

    of = f + '.mid'
    name = chart['name']
    meter = chart['style']['meter']
    tempo = chart['tempo']
    write_midi_file(of, sequences, name, meter, 4, tempo, key, is_minor)

DEBUG_SEED = None
#DEBUG_SEED = 980501219

if __name__ == '__main__':
    if not DEBUG_SEED:
        seed_value = randint(0, maxint)
    else:
        seed_value = DEBUG_SEED
    seed(seed_value)

    try:
        filelist = argv[1:]
        if filelist:
            for f in filelist:
                analyze_file(f)
        else:
            #PROFILE = True
            PROFILE = False

            if PROFILE:
                import profile
                profile.run("analyze_file('../../testfiles/Blues #40.mjb')")
            else:
                analyze_file('../../testfiles/Blues #40.mjb')
    except:
        print 'Random seed (please include in bug reports) =', seed_value
        print_exc()
