//
//  ClockController.m
//  SimpleDockClock
//
//  Created by Andrew Choi on 25/06/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//
//  Permission for the use of this code is granted only for research,
//  educational, and non-commercial purposes.
//
//  Redistribution of this code or its parts in any form without
//  permission, with or without modification, is prohibited.

#import "ClockController.h"


@implementation ClockController

- (void)drawClockHand:(NSImage *)handImage angle:(float)angle
{
	NSAffineTransform* xform = [NSAffineTransform transform];
	[xform translateXBy:64.0 yBy:64.0];
	[xform rotateByDegrees:-angle];
	[xform translateXBy:-64.0 yBy:-64.0];
	[xform set];

	[handImage drawAtPoint:NSZeroPoint fromRect:NSZeroRect operation:NSCompositeSourceOver fraction:1.0];
}

- (void)displayClock
{
	NSImage *icon = [[NSImage alloc] initWithSize:NSMakeSize(128.0, 128.0)];
	
	[icon lockFocus];
	
	[clockFaceImage compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
	
	NSCalendarDate *theTime = [NSCalendarDate calendarDate];
	float minuteHandAngle = 360.0 * ((float)[theTime minuteOfHour] / 60.0) + (360.0 / 60.0)
				    * ((float)[theTime secondOfMinute] / 60.0);
	float hourHandAngle = 360.0 * ((float)[theTime hourOfDay] / 12.0) + (360.0 / 12.0)
				    * ((float)[theTime minuteOfHour] / 60.0);

	[self drawClockHand:minuteHandImage angle:minuteHandAngle];
	[self drawClockHand:hourHandImage angle:hourHandAngle];
	
	[icon unlockFocus];
	
	[NSApp setApplicationIconImage:(NSImage *)icon];
	
	[icon release];
}

- (void)updateClock:(NSTimer*)theTimer
{
	NSCalendarDate *theTime = [NSCalendarDate calendarDate];
	
	timer = [NSTimer scheduledTimerWithTimeInterval:(float)(60 - [theTime secondOfMinute]) target:self selector:@selector(updateClock:) userInfo:nil repeats:NO];

	[self displayClock];
}

- (void)workspaceDidWake:(NSNotification *)notification
{
	[self updateClock:nil];
}

- (void)workspaceWillSleep:(NSNotification *)notification
{
	if ([timer isValid])
		[timer invalidate];
}

- (void) awakeFromNib
{
	clockFaceImage = [NSImage imageNamed:@"ClockFace"];
	minuteHandImage = [NSImage imageNamed:@"MinuteHand"];
	hourHandImage = [NSImage imageNamed:@"HourHand"];
	
	[self displayClock];
	
	NSCalendarDate *theTime = [NSCalendarDate calendarDate];
	
	timer = [NSTimer scheduledTimerWithTimeInterval:(float)(60 - [theTime secondOfMinute]) target:self selector:@selector(updateClock:) userInfo:nil repeats:NO];
	
	[[[NSWorkspace sharedWorkspace] notificationCenter] addObserver:self selector:@selector(workspaceDidWake:) name:NSWorkspaceDidWakeNotification object:nil];

	[[[NSWorkspace sharedWorkspace] notificationCenter] addObserver:self selector:@selector(workspaceWillSleep:) name:NSWorkspaceWillSleepNotification object:nil];
}

@end
