//
//  AppDelegate.m
//  SwitchMainDisplay
//
//  This program is original work by me.  I now place it in the public domain.  Do not plagiarize.
//  Created by Andrew Choi on 12-04-26.
//

#import "AppDelegate.h"

static void quitIfError(CGError e, NSString *m)
{
  if (e != kCGErrorSuccess)
  {
    NSBeep();
    NSLog(@"CGError: %@; error code = %u\n", m, e);
    [NSApp terminate:nil];
  }
}

@implementation AppDelegate

- (void)dealloc
{
  [super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
  uint32_t displayCount;
  CGError e = CGGetOnlineDisplayList(0, NULL, &displayCount);
  quitIfError(e, @"1st CGGetOnlineDisplayList (get displayCount) failed");

  CGDirectDisplayID *onlineDisplays = malloc(sizeof(CGDirectDisplayID) * displayCount);
  e = CGGetOnlineDisplayList(displayCount, onlineDisplays, &displayCount);
  quitIfError(e, @"2nd CGGetOnlineDisplayList (get list) failed");
  
  CGDirectDisplayID mainDisplayID = CGMainDisplayID();
  CGPoint originAdjust = CGDisplayBounds(mainDisplayID).origin;  

  // Find first display that isn't the main display.  May or may not exist.
  for (int i = 0; i < displayCount; ++i)
  {
    if (onlineDisplays[i] != mainDisplayID)
    {
      originAdjust = CGDisplayBounds(onlineDisplays[i]).origin;
      break;
    }
  }
  
  CGDisplayConfigRef cr;
  e = CGBeginDisplayConfiguration(&cr);
  quitIfError(e, @"CGBeginDisplayConfiguration failed");
  
  for (int i = 0; i < displayCount; ++i)
  {
    CGPoint o = CGDisplayBounds(onlineDisplays[i]).origin;
    
    e = CGConfigureDisplayOrigin(cr, onlineDisplays[i], (int32_t)lround(o.x - originAdjust.x), (int32_t)lround(o.y - originAdjust.y));
    quitIfError(e, @"CGConfigureDisplayOrigin failed");
  }
  
  e = CGCompleteDisplayConfiguration(cr, kCGConfigurePermanently);
  quitIfError(e, @"CGCompleteDisplayConfiguration failed");
  
  free(onlineDisplays);
  
  [NSApp terminate:self];
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
  return NSTerminateNow;
}

@end
