(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

module IntvlOrderedType =
struct
  type t = Intvl.t
  let compare x y = Intvl.compare x y
end

module Intvlset = Set.Make(IntvlOrderedType) 

let intvlset_of_intvllist il =
  List.fold_right Intvlset.add il Intvlset.empty

let invtlset_of_string_list sl =
  intvlset_of_intvllist (List.map Intvl.of_string sl)

let kind_map = [
  ("7", invtlset_of_string_list ["3"; "b7"]);
  ("Maj", invtlset_of_string_list ["3"; "5"]);
  ("m6", invtlset_of_string_list ["b3"; "5"; "6"]);
  ("m7", invtlset_of_string_list ["b3"; "5"; "b7"]);
  ("mMaj7", invtlset_of_string_list ["b3"; "5"; "7"]);
  ("m", invtlset_of_string_list ["b3"; "5"]);
  ("m7b5", invtlset_of_string_list ["b3"; "b5"; "b7"]);
  ("dim", invtlset_of_string_list ["b3"; "b5"; "6"])
]

let kinds = List.map (fun (k, _) -> k) kind_map

let of_chordtype chordtype =
  let intvlset = intvlset_of_intvllist chordtype in
    try
      let k, _ =
	List.find
	  (fun (k, is) -> Intvlset.subset is intvlset)
	  kind_map
      in
	k
    with _ ->
      "??"

let is_valid k =
  List.mem k kinds 
