(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = { root: Roman.t; kind: string }

let romanchord_re =
  let alt = "\\(#\\|b\\)?"
  and num = "\\(III\\|II\\|IV\\|VII\\|VI\\|V\\|I\\)" in
    Str.regexp ("^\\(" ^ alt ^ num ^ "\\)\\(.*\\)$")

let of_string s =
  if Str.string_match romanchord_re s 0 then
    let r = Str.matched_group 1 s and k = Str.matched_group 4 s in
      if Chordkind.is_valid k then
	{ root = Roman.of_string r; kind = k }
      else
	failwith ("Invalid kind: " ^ k)
  else
    failwith ("Invalid roman chord: " ^ s)

let of_root_kind r k =
  if Chordkind.is_valid k then
    { root = r; kind = k }
  else
    failwith ("Invalid kind: " ^ k)

let to_string rc =
  Roman.to_string rc.root ^ rc.kind

let pp formatter x = Format.pp_print_string formatter (to_string x)

let compare rc1 rc2 =
  let r = Roman.compare rc1.root rc2.root in
    if r = 0 then
      Pervasives.compare rc1.kind rc2.kind
    else
      r

(* Getters *)
let root rc = rc.root
let kind rc = rc.kind
