(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = { root: Note.t; kind: string; orig: Chord.t }

let of_chord c =
  let k = Chordkind.of_chordtype (Chord.chordtype c) in
    { root = Chord.root c; kind = k; orig = c }

let of_chord_name s =
  of_chord (Chord.of_string s)

let to_string sc =
  (Note.to_string sc.root) ^ sc.kind

let pp formatter x = Format.pp_print_string formatter (to_string x)

let compare sc1 sc2 =
  let r = Note.compare sc1.root sc2.root in
    if r = 0 then
      Pervasives.compare sc1.kind sc2.kind
    else
      r

(* Getters *)
let root sc = sc.root
let kind sc = sc.kind
let orig sc = sc.orig
