(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

open Structana
open Segment
open Annotate
open Output

let ana fn =
  let chart = Toereader.read fn in
    let a = Array.of_list (structana (List.concat chart.Chart.chords)) in
      let clsm = gen_clsm a and m_clsm = m_gen_clsm a in
	let dur = gen_dur a in
	  let dm = gen_dm clsm and m_dm = m_gen_dm m_clsm in
	    let n = Array.length a in
	      let em = gen_em clsm m_clsm dur n
	      and m_em = m_gen_em clsm m_clsm dur n in
		let d2m = gen_d2m dm em keys 
		and m_d2m = gen_d2m m_dm m_em m_keys in
		  let p = buildpart (optpart (gen_c d2m m_d2m a) n) a n in
		    let ap = annotate p in
		      let chords, bl, arrows, keys, brackets = dvi_output ap in
			text_output chords bl arrows keys brackets

let main () =
  let l = Array.length Sys.argv in
    if l < 2 then
      begin
	Printf.printf "Usage: t2 [-s] toefilename ...\n";
	exit 0
      end
    else
      for i = 1 to l - 1 do
	Printexc.print ana Sys.argv.(i)
      done

let _ = main ()
