(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

open Utils

let biab_chord_types = [|
  Some (Chordtype.of_string ":3.5");  (* "", 1 *)
  Some (Chordtype.of_string ":3.5");  (* "Maj", 2 *)
  Some (Chordtype.of_string ":3.b5");  (* "b5", 3 *)
  Some (Chordtype.of_string ":3.#5");  (* "aug", 4 *)
  Some (Chordtype.of_string ":3.5.6");  (* "6", 5 *)
  Some (Chordtype.of_string ":3.5.7");  (* "Maj7", 6 *)
  Some (Chordtype.of_string ":3.5.7.9");  (* "Maj9", 7 *)
  Some (Chordtype.of_string ":3.5.7.9.#11");  (* "Maj9#11", 8 *)
  Some (Chordtype.of_string ":3.5.7.9.#11.13");  (* "Maj13#11", 9 *)
  Some (Chordtype.of_string ":3.5.7.9.11.13");  (* "Maj13", 10 *)
  Some (Chordtype.of_string ":5.7.9");  (* "Maj9(no 3)", 11 *)
  Some (Chordtype.of_string ":3.#5");  (* "+", 12 *)
  Some (Chordtype.of_string ":3.#5.7");  (* "Maj7#5", 13 *)
  Some (Chordtype.of_string ":3.5.6.9");  (* "69", 14 *)
  Some (Chordtype.of_string ":2.5");  (* "2", 15 *)
  Some (Chordtype.of_string ":b3.5");  (* "m", 16 *)
  Some (Chordtype.of_string ":b3.#5");  (* "maug", 17 *)
  Some (Chordtype.of_string ":b3.5.7");  (* "mMaj7", 18 *)
  Some (Chordtype.of_string ":b3.5.b7");  (* "m7", 19 *)
  Some (Chordtype.of_string ":b3.5.b7.9");  (* "m9", 20 *)
  Some (Chordtype.of_string ":b3.5.b7.9.11");  (* "m11", 21 *)
  Some (Chordtype.of_string ":b3.5.b7.9.11.13");  (* "m13", 22 *)
  Some (Chordtype.of_string ":b3.5.6");  (* "m6", 23 *)
  Some (Chordtype.of_string ":b3.#5");  (* "m#5", 24 *)
  Some (Chordtype.of_string ":b3.#5.b7");  (* "m7#5", 25 *)
  Some (Chordtype.of_string ":b3.5.6.9");  (* "m69", 26 *)
  None;  (* "?", 27 *)
  None;  (* "?", 28 *)
  None;  (* "?", 29 *)
  None;  (* "?", 30 *)
  None;  (* "?", 31 *)
  Some (Chordtype.of_string ":b3.b5.b7");  (* "m7b5", 32 *)
  Some (Chordtype.of_string ":b3.b5");  (* "dim", 33 *)
  None;  (* "?", 34 *)
  None;  (* "?", 35 *)
  None;  (* "?", 36 *)
  None;  (* "?", 37 *)
  None;  (* "?", 38 *)
  None;  (* "?", 39 *)
  Some (Chordtype.of_string ":5");  (* "5", 40 *)
  None;  (* "?", 41 *)
  None;  (* "?", 42 *)
  None;  (* "?", 43 *)
  None;  (* "?", 44 *)
  None;  (* "?", 45 *)
  None;  (* "?", 46 *)
  None;  (* "?", 47 *)
  None;  (* "?", 48 *)
  None;  (* "?", 49 *)
  None;  (* "?", 50 *)
  None;  (* "?", 51 *)
  None;  (* "?", 52 *)
  None;  (* "?", 53 *)
  None;  (* "?", 54 *)
  None;  (* "?", 55 *)
  Some (Chordtype.of_string ":3.#5.b7");  (* "7+", 56 *)
  Some (Chordtype.of_string ":3.#5.b7.9");  (* "9+", 57 *)
  Some (Chordtype.of_string ":3.#5.b7.9.11.13");  (* "13+", 58 *)
  None;  (* "?", 59 *)
  None;  (* "?", 60 *)
  None;  (* "?", 61 *)
  None;  (* "?", 62 *)
  None;  (* "?", 63 *)
  Some (Chordtype.of_string ":3.5.b7");  (* "7", 64 *)
  Some (Chordtype.of_string ":3.5.b7.9.11.13");  (* "13", 65 *)
  Some (Chordtype.of_string ":3.5.b7.b13");  (* "7b13", 66 *)
  Some (Chordtype.of_string ":3.5.b7.#11");  (* "7#11", 67 *)
  Some (Chordtype.of_string ":3.5.b7.9.#11.13");  (* "13#11", 68 *)
  Some (Chordtype.of_string ":3.5.b7.#11.b13");  (* "7#11b13", 69 *)
  Some (Chordtype.of_string ":3.5.b7.9");  (* "9", 70 *)
  None;  (* "?", 71 *)
  Some (Chordtype.of_string ":3.5.b7.9.b13");  (* "9b13", 72 *)
  Some (Chordtype.of_string ":3.5.b7.9.#11");  (* "9#11", 73 *)
  Some (Chordtype.of_string ":3.5.b7.9.#11.13");  (* "13#11", 74 *)
  Some (Chordtype.of_string ":3.5.b7.9.#11.b13");  (* "9#11b13", 75 *)
  Some (Chordtype.of_string ":3.5.b7.b9");  (* "7b9", 76 *)
  Some (Chordtype.of_string ":3.5.b7.b9.11.13");  (* "13b9", 77 *)
  Some (Chordtype.of_string ":3.5.b7.b9.b13");  (* "7b9b13", 78 *)
  Some (Chordtype.of_string ":3.5.b7.b9.#11");  (* "7b9#11", 79 *)
  Some (Chordtype.of_string ":3.5.b7.b9.#11.13");  (* "13b9#11", 80 *)
  Some (Chordtype.of_string ":3.5.b7.b9.#11.b13");  (* "7b9#11b13", 81 *)
  Some (Chordtype.of_string ":3.5.b7.#9");  (* "7#9", 82 *)
  Some (Chordtype.of_string ":3.5.b7.#9.11.13");  (* "13#9", 83 *)
  Some (Chordtype.of_string ":3.5.b7.#9.b13");  (* "7#9b13", 84 *)
  Some (Chordtype.of_string ":3.5.b7.9.#11");  (* "9#11", 85 *)
  Some (Chordtype.of_string ":3.5.b7.#9.#11.13");  (* "13#9#11", 86 *)
  Some (Chordtype.of_string ":3.5.b7.#9.#11.b13");  (* "7#9#11b13", 87 *)
  Some (Chordtype.of_string ":3.b5.b7");  (* "7b5", 88 *)
  Some (Chordtype.of_string ":3.b5.b7.9.11.13");  (* "13b5", 89 *)
  Some (Chordtype.of_string ":3.b5.b7.b13");  (* "7b5b13", 90 *)
  Some (Chordtype.of_string ":3.b5.b7.9");  (* "9b5", 91 *)
  Some (Chordtype.of_string ":3.b5.b7.9.b13");  (* "9b5b13", 92 *)
  Some (Chordtype.of_string ":3.b5.b7.b9");  (* "7b5b9", 93 *)
  Some (Chordtype.of_string ":3.b5.b7.b9.11.13");  (* "13b5b9", 94 *)
  Some (Chordtype.of_string ":3.b5.b7.b9.b13");  (* "7b5b9b13", 95 *)
  Some (Chordtype.of_string ":3.b5.b7.#9");  (* "7b5#9", 96 *)
  Some (Chordtype.of_string ":3.b5.b7.#9.11.13");  (* "13b5#9", 97 *)
  Some (Chordtype.of_string ":3.b5.b7.#9.b13");  (* "7b5#9b13", 98 *)
  Some (Chordtype.of_string ":3.#5.b7");  (* "7#5", 99 *)
  Some (Chordtype.of_string ":3.#5.b7.9.11.13");  (* "13#5", 100 *)
  Some (Chordtype.of_string ":3.#5.b7.#11");  (* "7#5#11", 101 *)
  Some (Chordtype.of_string ":3.#5.b7.9.#11.13");  (* "13#5#11", 102 *)
  Some (Chordtype.of_string ":3.#5.b7.9");  (* "9#5", 103 *)
  Some (Chordtype.of_string ":3.#5.b7.9.#11");  (* "9#5#11", 104 *)
  Some (Chordtype.of_string ":3.#5.b7.b9");  (* "7#5b9", 105 *)
  Some (Chordtype.of_string ":3.#5.b7.b9.11.13");  (* "13#5b9", 106 *)
  Some (Chordtype.of_string ":3.#5.b7.b9.#11");  (* "7#5b9#11", 107 *)
  Some (Chordtype.of_string ":3.#5.b7.b9.#11.13");  (* "13#5b9#11", 108 *)
  Some (Chordtype.of_string ":3.#5.b7.#9");  (* "7#5#9", 109 *)
  Some (Chordtype.of_string ":3.#5.b7.#9.#11.13");  (* "13#5#9#11", 110 *)
  Some (Chordtype.of_string ":3.#5.b7.#9.#11");  (* "7#5#9#11", 111 *)
  Some (Chordtype.of_string ":3.#5.b7.#9.#11.13");  (* "13#5#9#11", 112 *)
  Some (Chordtype.of_string ":3.b5.#5.b7.b9.#9");  (* "7alt", 113 *)
  None;  (* "?", 114 *)
  None;  (* "?", 115 *)
  None;  (* "?", 116 *)
  None;  (* "?", 117 *)
  None;  (* "?", 118 *)
  None;  (* "?", 119 *)
  None;  (* "?", 120 *)
  None;  (* "?", 121 *)
  None;  (* "?", 122 *)
  None;  (* "?", 123 *)
  None;  (* "?", 124 *)
  None;  (* "?", 125 *)
  None;  (* "?", 126 *)
  None;  (* "?", 127 *)
  Some (Chordtype.of_string ":4.5.b7");  (* "7sus", 128 *)
  Some (Chordtype.of_string ":4.5.b7.9.11.13");  (* "13sus", 129 *)
  Some (Chordtype.of_string ":4.5.b7.b13");  (* "7susb13", 130 *)
  Some (Chordtype.of_string ":4.5.b7.#11");  (* "7sus#11", 131 *)
  Some (Chordtype.of_string ":4.5.b7.9.#11.13");  (* "13sus#11", 132 *)
  Some (Chordtype.of_string ":4.5.b7.#11.b13");  (* "7sus#11b13", 133 *)
  Some (Chordtype.of_string ":4.5.b7.9");  (* "9sus", 134 *)
  None;  (* "?", 135 *)
  Some (Chordtype.of_string ":4.5.b7.9.b13");  (* "9susb13", 136 *)
  Some (Chordtype.of_string ":4.5.b7.9.#11");  (* "9sus#11", 137 *)
  Some (Chordtype.of_string ":4.5.b7.9.#11.13");  (* "13sus#11", 138 *)
  Some (Chordtype.of_string ":4.5.b7.9.#11.b13");  (* "9sus#11b13", 139 *)
  Some (Chordtype.of_string ":4.5.b7.b9");  (* "7susb9", 140 *)
  Some (Chordtype.of_string ":4.5.b7.b9.11.13");  (* "13susb9", 141 *)
  Some (Chordtype.of_string ":4.5.b7.b9.13");  (* "7susb913", 142 *)
  Some (Chordtype.of_string ":4.5.b7.b9.#11");  (* "7susb9#11", 143 *)
  Some (Chordtype.of_string ":4.5.b7.b9.#11.13");  (* "13susb9#11", 144 *)
  Some (Chordtype.of_string ":4.5.b7.b9.#11.b13");  (* "7susb9#11b13", 145 *)
  Some (Chordtype.of_string ":4.5.b7.#9");  (* "7sus#9", 146 *)
  Some (Chordtype.of_string ":4.5.b7.#9.11.13");  (* "13sus#9", 147 *)
  Some (Chordtype.of_string ":4.5.b7.#9.b13");  (* "7sus#9b13", 148 *)
  Some (Chordtype.of_string ":4.5.b7.9.#11");  (* "9sus#11", 149 *)
  Some (Chordtype.of_string ":4.5.b7.#9.#11.13");  (* "13sus#9#11", 150 *)
  Some (Chordtype.of_string ":4.5.b7.#9.#11.b13");  (* "7sus#9#11b13", 151 *)
  Some (Chordtype.of_string ":4.b5.b7");  (* "7susb5", 152 *)
  Some (Chordtype.of_string ":4.b5.b7.9.11.13");  (* "13susb5", 153 *)
  Some (Chordtype.of_string ":4.b5.b7.b13");  (* "7susb5b13", 154 *)
  Some (Chordtype.of_string ":4.b5.b7.9");  (* "9susb5", 155 *)
  Some (Chordtype.of_string ":4.b5.b7.9.b13");  (* "9susb5b13", 156 *)
  Some (Chordtype.of_string ":4.b5.b7.b9");  (* "7susb5b9", 157 *)
  Some (Chordtype.of_string ":4.b5.b7.b9.11.13");  (* "13susb5b9", 158 *)
  Some (Chordtype.of_string ":4.b5.b7.b9.b13");  (* "7susb5b9b13", 159 *)
  Some (Chordtype.of_string ":4.b5.b7.#9");  (* "7susb5#9", 160 *)
  Some (Chordtype.of_string ":4.b5.b7.#9.11.13");  (* "13susb5#9", 161 *)
  Some (Chordtype.of_string ":4.b5.b7.#9.b13");  (* "7susb5#9b13", 162 *)
  Some (Chordtype.of_string ":4.#5.b7");  (* "7sus#5", 163 *)
  Some (Chordtype.of_string ":4.#5.b7.9.11.13");  (* "13sus#5", 164 *)
  Some (Chordtype.of_string ":4.#5.b7.#11");  (* "7sus#5#11", 165 *)
  Some (Chordtype.of_string ":4.#5.b7.9.#11.13");  (* "13sus#5#11", 166 *)
  Some (Chordtype.of_string ":4.#5.b7.9");  (* "9sus#5", 167 *)
  Some (Chordtype.of_string ":4.#5.b7.9.#11");  (* "9sus#5#11", 168 *)
  Some (Chordtype.of_string ":4.#5.b7.b9");  (* "7sus#5b9", 169 *)
  Some (Chordtype.of_string ":4.#5.b7.b9.11.13");  (* "13sus#5b9", 170 *)
  Some (Chordtype.of_string ":4.#5.b7.b9.#11");  (* "7sus#5b9#11", 171 *)
  Some (Chordtype.of_string ":4.#5.b7.b9.#11.13");  (* "13sus#5b9#11", 172 *)
  Some (Chordtype.of_string ":4.#5.b7.#9");  (* "7sus#5#9", 173 *)
  Some (Chordtype.of_string ":4.#5.b7.#9.#11.13");  (* "13sus#5#9#11", 174 *)
  Some (Chordtype.of_string ":4.#5.b7.#9.#11");  (* "7sus#5#9#11", 175 *)
  Some (Chordtype.of_string ":4.#5.b7.#9.#11.13");  (* "13sus#5#9#11", 176 *)
  Some (Chordtype.of_string ":4");  (* "4", 177 *)
  None;  (* "?", 178 *)
  None;  (* "?", 179 *)
  None;  (* "?", 180 *)
  None;  (* "?", 181 *)
  None;  (* "?", 182 *)
  None;  (* "?", 183 *)
  Some (Chordtype.of_string ":4.5");  (* "sus", 184 *)
  (* no chord names above 185 *) |]
  
let to_toe c =
  let i = c - 1 in
    assert (i >= 0 && i < Array.length biab_chord_types);

    let t = biab_chord_types.(i) in
      match t with
	  None -> failwith ("Unknown BiaB chord code: " ^ (string_of_int c))
	| Some chordtype -> Chordtype.to_string chordtype

let of_toe t =
  (index_array biab_chord_types (Some (Chordtype.of_string t))) + 1
