(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = {
  root : Note.t;
  chordtype : Chordtype.t;
  bass : Note.t;
  notes : Note.t list;
}
val of_string : string -> t
val to_string : t -> string
val pp : Format.formatter -> t -> unit
val nth : t -> int -> Note.t
val root : t -> Note.t
val chordtype : t -> Chordtype.t
val bass : t -> Note.t
val notes : t -> Note.t list
val compare : t -> t -> int
