(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

let define name strintvllist =
  Chordtype.define name (Intvllist.of_string strintvllist) in

  (* (Maj) Maj7 Maj9 6 69 Maj7#11 *)
  define "" "3.5";
  define "Maj7" "3.5.7";
  define "Maj9" "3.5.7.9";
  define "6" "3.5.6";
  define "69" "3.5.6.9";
  define "Maj7#11" "3.5.7.#11";

  (* sus 7sus 9sus *)
  define "sus" "4.5";
  define "7sus" "4.5.b7";
  define "9sus" "4.5.b7.9";

  (* m m7 m9 m11 m6 mMaj7 *)
  define "m" "b3.5";
  define "m7" "b3.5.b7";
  define "m9" "b3.5.b7.9";
  define "m11" "b3.5.b7.9.11";
  define "m6" "b3.5.6";
  define "mMaj7" "b3.5.7";

  (* 7 9 13 7b9 13b9 7#9 13#9 7b5 9b5 7#5 9#5 7+ 9+ 7#5#9 7b5b9 7#5b9 7b5#9 7#11 9#11 *)
  define "7" "3.5.b7";
  define "9" "3.5.b7.9";
  define "13" "3.5.b7.9.11.13";
  define "7b9" "3.5.b7.b9";
  define "13b9" "3.5.b7.b9.11.13";
  define "7#9" "3.5.b7.#9";
  define "13#9" "3.5.b7.#9.11.13";
  define "7b5" "3.b5.b7";
  define "9b5" "3.b5.b7.9";
  define "7#5" "3.#5.b7";
  define "9#5" "3.#5.b7.9";
  define "7+" "3.#5.b7";
  define "9+" "3.#5.b7.9";
  define "7#5#9" "3.#5.b7.#9";
  define "7b5b9" "3.b5.b7.b9";
  define "7#5b9" "3.#5.b7.b9";
  define "7b5#9" "3.b5.b7.#9";
  define "7#11" "3.5.b7.#11";
  define "9#11" "3.5.b7.9.#11";

  (* m7b5 dim *)
  define "m7b5" "b3.b5.b7";
  define "dim" "b3.b5.6";
  define "dim7" "b3.b5.6";

  (* + aug *)
  define "+" "3.#5";
  define "aug" "3.#5"
