(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

open Constants
open Utils

type t = { i: int; alt: int }

let intvl_re =
  let alt = "\\(\\(##\\|#\\|bb\\|b\\)?\\)" and i = "\\([1-9]\\|1[0-3]\\)" in
    Str.regexp ("^" ^ alt ^ i ^ "$")

let of_string s =
  if Str.string_match intvl_re s 0 then
    let alt = Str.matched_group 1 s and i = Str.matched_group 3 s in
      { i = int_of_string i - 1; alt = index_array alt_names alt - 2 }
  else
    failwith ("Invalid interval: " ^ s)

let to_string intvl =
  alt_names.(intvl.alt + 2) ^ string_of_int (intvl.i + 1)

let pp formatter x = Format.pp_print_string formatter (to_string x)

let of_i_alt i alt =
  if i < 0 || i > 12 then
    failwith ("Invalid i: " ^ (string_of_int i))
  else if alt < -2 || alt > 2 then
    failwith ("Invalid alt: " ^ (string_of_int alt))
  else
    { i = i; alt = alt }

let to_i_alt i =
  i.i, i.alt

let compare i1 i2 =
  Pervasives.compare (i1.i, i1.alt) (i2.i, i2.alt)

let equal i1 i2 =
  (i1.i, i1.alt) = (i2.i, i2.alt)

let hash i =
  Hashtbl.hash (i.i, i.alt)

let semi i =
  (semis.(i.i) + i.alt + 12) mod 12

let equiv i1 i2 =
  semi i1 = semi i2

