(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = Intvl.t list

let of_string s =
  let intvlnames = Str.split (Str.regexp "\\.") s in
    List.sort Intvl.compare (List.map Intvl.of_string intvlnames)

let to_string t =
  let join s1 s2 = if s1 = "" then s2 else s1 ^ "." ^ s2 in
    List.fold_left join "" (List.map Intvl.to_string t)

let nth intvllist n =
  let n1 = n - 1 in
  let rec find = function
      [] -> raise Not_found
    | x :: l ->
	let intvl = Intvl.of_i_alt n1 x in
	  if List.mem intvl intvllist then intvl else find l in
    find [0; 1; -1; 2; -2]

(* Assume both interval lists are sorted (as is the case if they were
   created by of_string.  *)
let rec compare il1 il2 =
  match (il1, il2) with
      (hd1 :: tl1, hd2 :: tl2) ->
	let r = Intvl.compare hd1 hd2 in
	  if r = 0 then
	    compare tl1 tl2
	  else
	    r
    | (_ :: _, []) -> 1
    | ([], _ :: _) -> -1
    | ([], []) -> 0
